<?php
/**
 * Open Source Social Network
 *
 * @package   (openteknik.com).ossn
 * @author    OSSN Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */
?>
<!-- <div class="row ossn-page-contents> dev3: replaced in order to achieve a centered layout -->
<div class="row ossn-page-contents justify-content-center">
		<div class="col-md-6 home-left-contents">
			<div class="logo">
            	<?php if(ossn_site_settings('cache') == true){?>
            	<img src="<?php echo ossn_theme_url();?>images/logo.png" />
                <?php } else { ?>
            	<img src="<?php echo ossn_theme_url();?>images/logo.png?v=<?php echo time();?>" />                
                <?php } ?>
            </div>	
            <div class="description">
            	<?php echo ossn_print('home:top:heading', array(ossn_site_settings('site_name'))); ?>
            </div>

			<!-- dev3 added login form logic as found in ~/system/plugins/default/pages/contents/user/login.php-->
			<?php 
				$error = input('error');
				if ($error == 1) { ?>
		        <div class="alert alert-danger">
		            <strong><?php echo ossn_print('login:error'); ?></strong><br/>
			        <p><?php echo ossn_print('login:error:sub'); ?></p>
		        </div>
	    	<?php } ?>       
	    	<?php 
			$contents = ossn_view_form('login2', array(
            		'id' => 'ossn-login',
           			'action' => ossn_site_url('action/user/login'),
        	));
			// dev5: don't embed the login form inside of the widget any longer

			/*
			echo ossn_plugin_view('widget/view', array(
						'title' => ossn_print('site:login'),
						'contents' => $contents,
			));
			*/

			// but display the bare form instead of our own structure
			?>
			<div class="ossn-widget">
				<div class="widget-contents">
					<?php
						echo $contents;
					?>
					<!-- additonal button added which is calling the separate 'register' page -->
					<a href="<?php echo ossn_site_url('register');?>" class="btn btn-success btn-sm"><?php echo ossn_print('create:account'); ?></a>
				</div>
			</div>	       			
 	   </div>   


</div>	
