<?php
/**
 * Homelancer Program/Software
 *
 * @package    	Homelancer Package for Ossn
 * @author     	Geocadin RA <ossn@homelancer.com>
 * @author_url 	http://www.homelancer.com/
 * @copyright  	2017 Homelancer.com
 * @license   	Homelancer License http://homelancer.com/license
 * @link      	http://homelancer.com/license
*/
header('Content-Type: application/json');

$user=array(
	'username' => input('username'),
	'password' => input('password'),
	'first_name' => input('firstname'),
	'last_name' => input('lastname'),
);

if (!empty($user)) {
    foreach ($user as $field => $value) {
        if (empty($value)) {
            $json['error'] = '1';
        }
    }
}
if (isset($json['error']) && !empty($json['error'])) {
    echo json_encode($json);
    exit;
}
	
$activation=input('signup');
$user['email'] = input('email');
$user['guid'] = input('guid');

$add = new OssnUser;
$add->guid=$user['guid'];
$add = $add->getUser();
$entityusername=$add->username;

$add->username = $user['username'];
$add->password = $user['password'];
$add->first_name = $user['first_name'];
$add->last_name = $user['last_name'];

//check if activation is valid
if($add->activation!=$activation){
    $em['dataerr'] = ossn_print('system:error:text');
    echo json_encode($em);
    exit;		
}

//check if email is valid 
if($add->email!=$user['email']){
    $em['dataerr'] = ossn_print('email:error:matching');
    echo json_encode($em);
    exit;		
}

if (!$add->isUsername()) {
    $em['dataerr'] = ossn_print('username:error');
    echo json_encode($em);
    exit;
}

//check if username exists
$params=array(
	'from' => 'ossn_users',
	'wheres' => array(
		'username="'.$user['username'].'"'
	),
);
$userX = $add->select($params);
if(!empty($userX) && ($userX->guid!=$user['guid'])){
    $em['dataerr'] = ossn_print('username:inuse');
    echo json_encode($em);
    exit;	
}

if (!$add->isPassword()) {
    $em['dataerr'] = ossn_print('password:error');
    echo json_encode($em);
    exit;
}

$user['salt'] = $add->generateSalt();
$user['password'] = $add->generate_password($user['password'], $user['salt']);
$user['type'] = $add->type;
$user['activation'] = '';
	
$entity = ossn_user_by_username($entityusername);

$OssnDatabase = new OssnDatabase;
$params=array(
	'table' => 'ossn_users',
	'wheres' => array("guid='{$entity->guid}'"),
	'names' => array_keys($user),
	'values' => array_values($user)
);


//save
if ($OssnDatabase->update($params)) {
    //update entities
    $guid = $entity->guid;
    if (!empty($guid)) {
        $entity->owner_guid = $guid;
        $entity->type = 'user';
		
		$entity->data = new stdClass;
		$fields=array_keys($user);
		foreach($fields as $items){
				foreach($items as $field){
						$entity->data->{$field} = $user[$field];
				}
		}		
        $entity->save();
    }
	$message=ossn_print('account:created').'<br/>'.ossn_print('rsvp:confirmed');	
	ossn_trigger_message($message);	
    $em['success'] = 1;
    $em['datasuccess'] = ossn_site_url().'login/';
    echo json_encode($em);
	exit;
} else {
    $em['dataerr'] = ossn_print('account:create:error:admin');
    echo json_encode($em);
    exit;
}

