<?php
/**
 * Homelancer Program/Software
 *
 * @package    	Homelancer Package for Ossn
 * @author     	Geocadin RA <ossn@homelancer.com>
 * @author_url 	http://www.homelancer.com/
 * @copyright  	2017 Homelancer.com
 * @license   	Homelancer License http://homelancer.com/license
 * @link      	http://homelancer.com/license
*/


define('__RSVP__', ossn_route()->com . 'RSVP/');
function rsvp(){
	global $Ossn;
	
	//this will register components/rsvp/plugins/default/
	ossn_register_plugins_by_path(__RSVP__.'plugins/');	
		
	//Register the rsvp page handler 
	ossn_register_page('rsvp', 'rsvp_pagehandler');
	
	if (!ossn_isLoggedin()){
		//Setup the CSS and JS
		ossn_extend_view('css/ossn.default', 'css/rsvp');
		ossn_extend_view('js/opensource.socialnetwork', 'js/rsvp');
		
		//Replace the register user action from the logged-off users
		ossn_unregister_action('user/register');
		ossn_register_action('rsvp/signup', __RSVP__.'actions/signup.php');
		
	} else {
		ossn_add_hook('email', 'send:policy', 'rsvp_invitation');	
		ossn_add_hook('email', 'send', 'rsvp_invitation');	
	}
	
	return;
}

function rsvp_invitation($hook, $type, $args, $params){
	$site = ossn_site_settings('site_name');
	$site = html_entity_decode($site, ENT_QUOTES, "UTF-8");
	$subject = ossn_print("com:ossn:invite:mail:subject", array($site));
	if (empty($args) || $args->Subject!=$subject){
		return $args;
	}
	$email = $args->address;
	$xmail = explode('@',$email);
	$firstname = $xmail[0];
	$lastname = $xmail[1];
	$username = md5($email);
	$password = md5(time());
	
	$add = new OssnUser;
	$add->username = $username;
	$add->first_name = $firstname;
	$add->last_name = $lastname;
	$add->email = $email;
	$add->password = $password;
	$add->sendactiviation = false;
	if (!$add->addUser()) {
		return false;
	}
	//refresh added user
	$add=$add->getUser();
	
	$url = ossn_site_url().'rsvp/signup/'.$add->guid.'/'.$add->activation;
	$user = ossn_loggedin_user();
	$user_fullname = html_entity_decode($user->fullname, ENT_QUOTES, "UTF-8");
	$message = $params['message'];
	if(empty($message)){
		$message=$url;
	}
		
	$params = array($site, $user_fullname, $message, $url, $user->profileURL());	
	$message = ossn_print("com:ossn:invite:mail:message", $params);			
	$args->Body = $message;
	
	return $args;
	
}

function rsvp_pagehandler($pages) {
	if (ossn_isLoggedin()){
		ossn_trigger_message(ossn_print('rsvp:logout'),'error');
		redirect(REF);
	}
	
	$page = $pages[0];
	$guid = $pages[1];
	if(empty($page) || $page!='signup') {
		redirect(REF);
	}
	
	if (empty($guid)){
		ossn_action('rsvp/signup');
		return;
	}	
	$activation = $pages[2];
	$user = new OssnUser;
	$user->guid = $guid;
	$user = $user->getUser();
	if (!empty($user) && $user->activation==$activation){
		$title = ossn_print('create:account');
		$params['title']=$title;
		$params['user']=$user;
		$content=ossn_view_form('signup', array(
			'action' => ossn_site_url('rsvp/signup'),
			'component' => 'rsvp',
			'id' => 'home-rsvp-signup',
			'params' => $params,
		), false);		
		$contents=array('content'=>$content);
		$content = ossn_set_page_layout('startup', $contents);
		echo ossn_view_page($title, $content);	
		return;
	}
	if (!empty($user) && empty($user->activation)){
		ossn_trigger_message(ossn_print('rsvp:active'),'success');
	} else {
		ossn_trigger_message(ossn_print('rsvp:invalid'),'error');
	}
	redirect($REF);
	
}	
ossn_register_callback('ossn', 'init', 'rsvp');