/**
 * Open Source Social Network
 *
 * @package    Homelancer Package for Ossn
 * @author     Geocadin RA <ossn@homelancer.com>
 * @author_url http://www.homelancer.com/
 * @copyright  2017 Homelancer.com
 * @license    General Public Licence http://www.opensource-socialnetwork.org/licence
 * @link       http://www.opensource-socialnetwork.org/licence
 */
/**
 * Setup ajax request for user register
 *
 * @return void
 */
Ossn.RegisterStartupFunction(function() {
	Ossn.ajaxRequest({
		url: Ossn.site_url + "rsvp/signup",
		form: '#home-rsvp-signup',

		beforeSend: function(request) {
			var failedValidate = false;
			$('#ossn-submit-button').show();
			$('#home-rsvp-signup .ossn-loading').addClass("ossn-hidden");

			$('#home-rsvp-signup').find('#ossn-signup-errors').hide();
			$('#home-rsvp-signup input').filter(function() {
				$(this).closest('span').removeClass('ossn-required');
				if (this.value == "") {
					$(this).addClass('ossn-red-borders');
					failedValidate = true;
					request.abort();
					return false;
				}
			});
			if (failedValidate == false) {
				$('#ossn-submit-button').hide();
				$('#home-rsvp-signup .ossn-loading').removeClass("ossn-hidden");
			}
		},
		callback: function(callback) {
			if (callback['dataerr']) {
				$('#home-rsvp-signup').find('#ossn-signup-errors').html(callback['dataerr']).fadeIn();
				$('#ossn-submit-button').show();
				$('#home-rsvp-signup .ossn-loading').addClass("ossn-hidden");
			} else if (callback['success'] == 1) {
				window.location=callback['datasuccess'];
			} else {
				$('#home-rsvp-signup .ossn-loading').addClass("ossn-hidden");
				$('#ossn-submit-button').attr('type', 'submit')
				$('#ossn-submit-button').attr('style', 'opacity:1;');
			}
		}
	});
});

