<?php
/**
 * @package Homelancer Add-ons Manager for Ossn
 */
$users      = new OssnUser;
$pagination = new OssnPagination;
$search = input('search_users');

$data = $users->getUnvalidatedUSERS($search);

$pagination->setItem($data);
$list = $pagination->getItem();

?>
<div class="row">
    <form method="post">
        <input type="text" name="search_users" placeholder="<?php echo ossn_print('search'); ?>" />
        <input type="submit" class="btn btn-primary" value="<?php echo ossn_print('search'); ?>"/>
    </form>    
</div>
<div class="row margin-top-10">
<table class="table ossn-users-list">
    <tbody>
    <tr class="table-titles">
        <th><?php echo ossn_print('name'); ?></th>
        <th><?php echo ossn_print('username'); ?></th>
        <th><?php echo ossn_print('email'); ?></th>
        <th><?php echo ossn_print('type'); ?></th>
        <th><?php echo ossn_print('created'); ?></th>
        <th><?php echo ossn_print('resend:validation'); ?></th>
        <th><?php echo ossn_print('validate'); ?></th>
        <th><?php echo ossn_print('edit'); ?></th>
        <th><?php echo ossn_print('delete'); ?></th>
    </tr>
    <?php
if($list) {
		foreach($pagination->getItem() as $user) {
				$user      = ossn_user_by_guid($user->guid);
		$created = '';
		if(!empty($user->time_created)){
			$created = ossn_user_friendly_time($user->time_created);
		}
				
?>
        <tr>
            <td>
                <div class="left image"><img src="<?php echo $user->iconURL()->smaller; ?>"/></div>
                <div class="name"><?php echo $user->fullname; ?></div>
            </td>
            <td><?php echo $user->username;?></td>
            <td><?php echo $user->email; ?></td>
            <td><?php echo $user->type; ?></td>
            <td><?php echo $created; ?></td>
			
            <td><a href="<?php echo ossn_site_url("action/admin/resendvalidation/user?guid={$user->guid}", true); ?>"><?php echo ossn_print('resend:validation'); ?></a></td>
            <td><a href="<?php echo ossn_site_url("action/admin/validate/user?guid={$user->guid}", true); ?>"><?php echo ossn_print('validate'); ?></a></td>
            <td>
                <a href="<?php echo ossn_site_url("administrator/edituser/{$user->username}");?>"><?php echo ossn_print('edit'); ?></a>
            </td>
            <td><a href="<?php echo ossn_site_url("action/admin/delete/user?guid={$user->guid}", true); ?>"><?php echo ossn_print('delete'); ?></a></td>
        </tr>
    <?php
		}
}
?>
    </tbody>
</table>
</div>
<div class="row">
	<?php echo $pagination->pagination(); ?>
</div>
