//<script>
Ossn.add_hook('profile', 'birthdate:input', 'custom_birthdate_init');
function custom_birthdate_init(hook, type, ret, params){
    // Configuration for minimum 14 years and maximum 30 years
    ret.minDate     = '-30Y'; // Maximum 30 years ago
    ret.maxDate     = '-14Y'; // Minimum 14 years ago
    ret.yearRange   = '-30:-14';

    ret.dateFormat  = 'dd.mm.yy';
    ret.beforeShow  = function(input, inst) {
        // Hide the calendar
        $('#ui-datepicker-div').css('display', 'none');
        
        // Disable manual keyboard input
        $(this).prop('readonly', true);
    };
    ret.onClose     = function(selectedDate) {
        validateAge(selectedDate);
        $(this).datepicker('setDate', selectedDate);
    };
    return ret;

    function validateAge(selectedDate) {
        var currentDate = new Date();
        var selectedDateObj = $.datepicker.parseDate('dd.mm.yy', selectedDate);
        var ageDifference = currentDate.getFullYear() - selectedDateObj.getFullYear();

        if (ageDifference < 14) {
            alert('Sie müssen mindestens 14 Jahre alt sein.');
            // Additional action if the condition is not met
        } else if (ageDifference > 30) {
            alert('Sie müssen maximal 30 Jahre alt sein.');
            // Additional action if the condition is not met
        }
        // Additional actions can be added here if needed
    }
}
