<?php
/**
 * Open Source Social Network
 * @link      https://www.opensource-socialnetwork.org/
 * @package   Intro
 * @author    Allon Prooit <AT3META@3NCIRCLE.COM>
 * @copyright (C) Allon Prooit
 * @license   GNU General Public License https://www.gnu.de/documents/gpl-2.0.en.html
 */

define('__INTRO__', ossn_route()->com . 'intro/');
require_once(__INTRO__ . 'classes/Intro.php');
/**
 * Initialize component
 *
 * @return void
 */
function com_intro_init()
{
	ossn_extend_view('css/ossn.default', 'css/intro');
	ossn_profile_subpage('intro');

	ossn_register_callback('page', 'load:profile', 'com_intro_profile_intro_menu');
	ossn_add_hook('profile', 'subpage', 'com_intro_profile_intro_page');
	ossn_add_hook('required', 'components', 'com_intro_asure_requirements');

	ossn_register_callback('page', 'load:search', 'com_intro_search_menu_link');
	ossn_add_hook('search', 'type:intro', 'com_intro_search_intros_handler');

	if (ossn_isLoggedin()) {
		ossn_add_hook('profile', 'edit:section', 'com_intro_profile_edit_section_page');	
		ossn_register_menu_item('profile/edit/tabs', array(
			'name' => 'intro',
			'href' => '?section=intro',
			'text' => ossn_print('intro'),
		));
		ossn_register_action('intro/edit_intro', __INTRO__ . 'actions/intro/edit_intro.php');

//		ossn_add_hook('profile', 'modules', 'com_intro_hook');
		ossn_add_hook('profile', 'modules', 'com_intro_widget_hook', 99);
	}
}

function com_intro_asure_requirements($hook, $type, $return, $params)
{
	$return[] = 'OssnProfile';
	$return[] = 'TextareaSupport';
	return $return;
}

/**
 * Register the 'intro' menu tab on member profile
 *
 * @return void
 */
function com_intro_profile_intro_menu()
{
	$owner = ossn_user_by_guid(ossn_get_page_owner_guid());
	if ($owner && isset($owner->intro)) {
		if (!isset($owner->intro_access) || (isset($owner->intro_access) && $owner->intro_access == OSSN_PUBLIC || ($owner->intro_access == OSSN_FRIENDS && ossn_isLoggedin() && ossn_loggedin_user()->isFriend(ossn_loggedin_user()->guid, $owner->guid)) || (ossn_isLoggedin() && ossn_loggedin_user()->guid == $owner->guid) || ossn_isAdminLoggedin())) {
			ossn_register_menu_link('intro', 'intro', $owner->profileURL('/intro'), 'user_timeline');
		}
	}
}

/**
 * Add a pagehandler for the 'intro' sub page
 *
 * @return string
 */
function com_intro_profile_intro_page($hook, $type, $return, $params)
{
	$page = $params['subpage'];
	if ($page == 'intro' && isset($params['user']->intro)) {
		if (!isset($params['user']->intro_access) || (isset($params['user']->intro_access) && $params['user']->intro_access == OSSN_PUBLIC || ($params['user']->intro_access == OSSN_FRIENDS && ossn_isLoggedin() && ossn_loggedin_user()->isFriend(ossn_loggedin_user()->guid, $params['user']->guid)) || (ossn_isLoggedin() && ossn_loggedin_user()->guid == $params['user']->guid) || ossn_isAdminLoggedin())     ) {
			$intro_content = ossn_call_hook('textarea', 'purify', false, $params['user']->intro);
			$intro_content = ossn_call_hook('textarea', 'responsify', false, $intro_content); 
			$params['user']->intro = $intro_content;
			$content = ossn_plugin_view('profile/intro', $params);
			echo ossn_set_page_layout('module', array(
				'title' => ossn_print('com:intro:pagetitle'),
				'content' => $content
			));
		}
	}
}
//function com_intro_widget_hook($hook, $type, $modules, $params) {
//	if (!isset($params['user']->intro_access) || (isset($params['user']->intro_access) && $params['user']->intro_access == OSSN_PUBLIC || ($params['user']->intro_access == OSSN_FRIENDS && ossn_isLoggedin() && ossn_loggedin_user()->isFriend(ossn_loggedin_user()->guid, $params['user']->guid)) || (ossn_isLoggedin() && ossn_loggedin_user()->guid == $params['user']->guid) || ossn_isAdminLoggedin())     ) {
//		$intro_content = ossn_call_hook('textarea', 'purify', false, $params['user']->intro);
//		$intro_content = ossn_call_hook('textarea', 'responsify', false, $intro_content); 
//		$params['user']->intro = $intro_content;
//		$content = ossn_plugin_view('profile/widget', $params);
//		$return[] = $content;
//	}
//	return $return;
//}
function com_intro_widget_hook($hook, $type, $return, $params) {
	if (!isset($params['user']->intro_access) || (isset($params['user']->intro_access) && $params['user']->intro_access == OSSN_PUBLIC || ($params['user']->intro_access == OSSN_FRIENDS && ossn_isLoggedin() && ossn_loggedin_user()->isFriend(ossn_loggedin_user()->guid, $params['user']->guid)) || (ossn_isLoggedin() && ossn_loggedin_user()->guid == $params['user']->guid) || ossn_isAdminLoggedin())     ) {
    $intro_content = ossn_call_hook('textarea', 'purify', false, $params['user']->intro);
    $intro_content = ossn_call_hook('textarea', 'responsify', false, $intro_content); 
    $params['user']->intro = $intro_content;
    $content = ossn_plugin_view('profile/widget', $params);
	$return[] = $content;
	}
	return $return;
}

//function com_intro_hook($hook, $type, $modules, $vars){
        //$vars['user'] contains user instance (OssnUser)
        //we extend exsting modules array
//        $modules[] = ossn_plugin_view('profile/widget');
//        return $modules;
//}

/**
 * intro search handler
 *
 * @return mixdata;
 * @access private
 */

function com_intro_search_intros_handler($hook, $type, $return, $params)
{
	$count = 0;
	$query = input('q');
	$converted_query = htmlspecialchars(htmlentities($query));
	if (ossn_isLoggedin()) {
		$visitor = ossn_loggedin_user();
		$is_admin = ossn_isAdminLoggedin();
		if (com_is_active('OssnBlock')) {
			$blocked_check = true;
		} else {
			$blocked_check = false;
		}
	} else {
		$visitor = false;
		$is_admin = false;
		$blocked_check = false;
	}
		$intro = new intro();
		$search_options = array(
			'query' => $converted_query,
			'count' => false,
			'visitor' => $visitor,
			'is_admin' => $is_admin,
			'blocked_check' => $blocked_check
		);
		$intros = $intro->searchintros($search_options);
		$search_options['count'] = true;
		$count = $intro->searchintros($search_options);
		if ($count && $intros) {
			$found['intros'] = $intros;
			if (!strlen($query)) {
				$found['page_header'] = ossn_print('com:intro:search:result:total', array($count));
			} else {
				$found['page_header'] = ossn_print('com:intro:search:result', array($count, $query));
			}
			$search = ossn_plugin_view('intro/pages/search_results', $found);
			$search .= ossn_view_pagination($count);
			return $search;
		}
		$found['intros'] = false;
		$found['page_header'] = ossn_print('com:intro:search:noresult', array($query));
		$search = ossn_plugin_view('intro/pages/search_results', $found);
		return $search;
}

/**
 * Add links to search page menu
 *
 * @return void;
 * @access private
 */
function com_intro_search_menu_link($event, $type, $params)
{
	$url = OssnPagination::constructUrlArgs(array(
		'type'
	));
	ossn_register_menu_link('com_intro_search_intro', 'intro', "search?type=intro{$url}", 'search');
}

function com_intro_profile_edit_section_page($hook, $type, $return, $params)
{
	if ($params['section'] == 'intro') {
		return ossn_plugin_view('account_settings/intro/intro_tab');
	}
}

ossn_register_callback('ossn', 'init', 'com_intro_init');