<?php
/**
 * Open Source Social Network
 * @link      https://www.opensource-socialnetwork.org/
 * @package   Intro
 * @author    Allon Prooit
 * @copyright (C) 3NCIRCLE.COM
 * @license   GNU General Public License https://www.gnu.de/documents/gpl-2.0.en.html
 */
$intro_access_options = array(
	OSSN_PUBLIC,
	OSSN_FRIENDS
);
foreach ($intro_access_options as $option) {
	 $intro_access_option_strings[$option] = ossn_print("com:intro:accessibility:option:{$option}"); 
}

echo ossn_plugin_view('input/textarea', array(
	'label' => 'intro',
	'class' => 'ossn-editor',
	'name'  => 'intro',
	'value' => html_entity_decode($params['intro']),
	'placeholder' => ossn_print('com:intro:placeholder')
));
?>
<br />
<h6><?php echo ossn_print('com:intro:visibility'); ?></h6>
<?php
echo ossn_plugin_view('input/radio', array(
	'name' => 'intro_access',
	'value' => ((int) $params['intro_access'] ?: OSSN_PUBLIC),
	'options' => $intro_access_option_strings,
	'class' => ''
));

?>
<br />
<input type="hidden" value="<?php echo $params['username']; ?>" name="username"/>
<input type="submit" class="btn btn-primary" value="<?php echo ossn_print('save'); ?>"/>
