document.addEventListener('DOMContentLoaded', function () {
	let refreshDiv = document.createElement('div');
	refreshDiv.className = 'refresh';
	refreshDiv.textContent = 'Refreshing...';
	// some add-ons for cleaner placement on Goblue's topbar
	refreshDiv.style.position = 'absolute';
	refreshDiv.style.zIndex = '10';
	refreshDiv.style.color = '#f00';
	refreshDiv.style.top = '-50px';
	//
	document.body.prepend(refreshDiv);

	let startY = 0;
	let isPulling = false;

	document.addEventListener('touchstart', function (e) {
		if (window.scrollY === 0) {
			console.log('TOUCH START... ', window.scrollY, ' ', e.touches[0].clientY);
			startY = e.touches[0].clientY;
		}
	});

 	document.addEventListener('touchmove', function (e) {
 		if (window.scrollY === 0 && e.touches[0].clientY > startY) {
 			let diff = e.touches[0].clientY - startY;
 			if (diff > 50) {
 				isPulling = true;
 				refreshDiv.style.top = '0';
 			} else {
 				refreshDiv.style.top = '-50px';
 				isPulling = false;
 			}
			console.log('SWIPING ... distance  ', diff);
		}
 	});

 	document.addEventListener('touchend', function (e) {
		console.log('TOUCH END ... being pulled ', isPulling);
		if (isPulling) {
 			setTimeout(function () {
 				refreshDiv.style.top = '-50px';
 				alert('Content refreshed!');
 			}, 1000);
 		}
 		isPulling = false;
 	});
});