<?php
// Suchabfrage verarbeiten, falls vorhanden
$search_query = input('q');

// Prüfe, ob die DisplayUsername-Komponente aktiv ist
$use_username_only = com_is_active('DisplayUsername');
?>

<div>
    <label><?php echo ossn_print('com:allusers:search:placeholder'); ?></label>
    <form method="GET" action="<?php echo ossn_site_url('administrator/component/AllUsers'); ?>">
        <input type="text" name="q" value="<?php echo htmlspecialchars($search_query); ?>" placeholder="<?php echo ossn_print('com:allusers:search:placeholder'); ?>" />
        <button type="submit" class="btn btn-success"><?php echo ossn_print('com:allusers:search:button'); ?></button>
    </form>
</div>

<?php
if (!empty($search_query)) {
    // SQL-Abfrage vorbereiten
    $database = new OssnDatabase();

    if ($use_username_only) {
        // Nur nach Benutzernamen suchen, wenn DisplayUsername aktiv ist
        $sql = "SELECT guid FROM ossn_users WHERE username LIKE '%{$search_query}%'";
    } else {
        // Nach GUID, Vorname oder Nachname suchen
        $sql = "SELECT guid FROM ossn_users WHERE guid LIKE '%{$search_query}%' 
                OR first_name LIKE '%{$search_query}%' 
                OR last_name LIKE '%{$search_query}%'";
    }

    // SQL-Abfrage ausführen
    $database->statement($sql);
    $database->execute();
    $users = $database->fetch(true);

    echo "<h2>" . ossn_print('com:allusers:page:title') . "</h2>";
    if ($users) {
		foreach ($users as $user) {
		    $user_data = ossn_user_by_guid($user->guid);
		    $profile_url = ossn_site_url() . "u/{$user_data->username}";

		    // GUID immer anzeigen, unabhängig davon, ob DisplayUsername aktiv ist
		    echo ossn_print('com:allusers:user:guid') . ": {$user_data->guid} - ";

		    if ($use_username_only) {
		        // Nur den Benutzernamen anzeigen, wenn DisplayUsername aktiv ist
		        echo ossn_print('com:allusers:user:name') . ": <a href='{$profile_url}'>{$user_data->username}</a><br>";
		    } else {
		        // Ansonsten vollständige Details anzeigen
		        echo ossn_print('com:allusers:user:name') . ": <a href='{$profile_url}'>{$user_data->first_name} {$user_data->last_name}</a><br>";
		    }
		}

    } else {
        echo ossn_print('com:allusers:no_users_found');
    }
}
?>
