<?php
// Suchabfrage verarbeiten, falls vorhanden
$search_query = input('q');

// Prüfe, ob die DisplayUsername-Komponente aktiv ist
$use_username_only = com_is_active('DisplayUsername');

// Dynamischer Platzhalter für das Suchfeld
if ($use_username_only) {
    $placeholder_text = ossn_print('com:allusers:search:by_username');
} else {
    $placeholder_text = ossn_print('com:allusers:search:by_firstname');
}
?>

<div>
    <label><?php echo $placeholder_text; ?></label>
    <form method="GET" action="<?php echo ossn_site_url('administrator/component/AllUsers'); ?>">
        <input type="text" name="q" value="<?php echo htmlspecialchars($search_query); ?>" placeholder="<?php echo $placeholder_text; ?>" />
        <button type="submit" class="btn btn-success"><?php echo ossn_print('com:allusers:search:button'); ?></button>
    </form>
</div>

<?php
if (!empty($search_query)) {
    // SQL-Abfrage vorbereiten
    $database = new OssnDatabase();

    if ($use_username_only) {
        // Nur nach Benutzernamen suchen, wenn DisplayUsername aktiv ist
        $sql = "SELECT guid FROM ossn_users WHERE username LIKE '%{$search_query}%'";
    } else {
        // Nach GUID, Vorname oder Nachname suchen, bei mehreren Wörtern
        $search_terms = explode(' ', $search_query); // Suchbegriff in einzelne Wörter aufteilen
        $where_clauses = array();

        foreach ($search_terms as $term) {
            $term = htmlspecialchars($term); // Escape für Sicherheit
            $where_clauses[] = "(first_name LIKE '%{$term}%' OR last_name LIKE '%{$term}%')";
        }

        // Die SQL-Abfrage kombiniert die Bedingungen mit AND, sodass alle Wörter übereinstimmen müssen
        $sql = "SELECT guid FROM ossn_users WHERE guid LIKE '%{$search_query}%' 
                OR (" . implode(' AND ', $where_clauses) . ")";
    }

    // SQL-Abfrage ausführen
    $database->statement($sql);
    $database->execute();
    $users = $database->fetch(true);

    echo "<h2>" . ossn_print('com:allusers:page:title') . "</h2>";
    if ($users) {
        foreach ($users as $user) {
            $user_data = ossn_user_by_guid($user->guid);
            $profile_url = ossn_site_url() . "u/{$user_data->username}";

            // GUID immer anzeigen, unabhängig davon, ob DisplayUsername aktiv ist
            echo ossn_print('com:allusers:user:guid') . ": {$user_data->guid} - ";

            if ($use_username_only) {
                // Nur den Benutzernamen anzeigen, wenn DisplayUsername aktiv ist
                echo ossn_print('com:allusers:user:name') . ": <a href='{$profile_url}'>{$user_data->username}</a><br>";
            } else {
                // Ansonsten vollständige Details anzeigen
                echo ossn_print('com:allusers:user:name') . ": <a href='{$profile_url}'>{$user_data->first_name} {$user_data->last_name}</a><br>";
            }
        }

    } else {
        echo ossn_print('com:allusers:no_users_found');
    }
}
?>
