document.addEventListener('DOMContentLoaded', function() {
    // Function to handle delete confirmation and request
    function handleDelete(event, message, isPost) {
        // Prevent the default action and stop propagation 
        event.preventDefault();
        event.stopImmediatePropagation();

        // Display a confirmation dialog
        var userConfirmed = confirm(message);

        if (userConfirmed) {
            // If the user confirmed, proceed with the deletion
            var deleteUrl = event.target.getAttribute('href');

            // Use fetch to send a request to the delete URL
            fetch(deleteUrl, {
                method: 'GET',
                credentials: 'same-origin'
            })
            .then(response => {
                if (response.ok) {
                    // Reload the page after successful deletion
                    location.reload();
                } else {
                    console.error(Ossn.Print('delete:failed'));
                }
            })
            .catch(error => console.error(Ossn.Print('error')));
        } else {
            // If the user cancelled, do nothing
            console.log(Ossn.Print('delete:cancelled'));
        }
    }

    // Event delegation for dynamically added comments, GIFs, and posts
    document.body.addEventListener('click', function(event) {
        var target = event.target;

        // Check if the clicked element is a delete button for comments (including GIFs)
        if (target.matches('a.dropdown-item.ossn-delete-comment, .dropdown-item.ossn-delete-comment, .ossn-delete-comment')) {
            handleDelete(event, Ossn.Print('delete:confirm:comment'), false);
        }

        // Check if the clicked element is a delete button for posts
        if (target.matches('.dropdown-item.post-control-delete.ossn-wall-post-delete')) {
            handleDelete(event, Ossn.Print('delete:confirm:post'), true);
        }
    });
});
