document.addEventListener('DOMContentLoaded', function() {
    // Verwende die Werte von currentUserGUID und blockedGUIDs aus dem globalen Kontext
    console.log('DeactivateWall: Benutzer GUID:', currentUserGUID);
    console.log('DeactivateWall: Blockierte GUIDs:', blockedGUIDs);

    function disableElement(element) {
        element.disabled = true;  // Deaktiviert das Element (falls es ein Eingabeelement ist)
        element.tabIndex = -1;   // Entfernt das Element aus der Tabulatorreihenfolge
        element.style.pointerEvents = 'none'; // Blockiert jegliche Interaktion mit dem Element

        // Erstellt ein überlagerndes DIV-Element mit einer eindeutigen Klasse, das Klicks abfängt
        var overlay = document.createElement('div');
        overlay.className = 'element-overlay';  // Füge eindeutige Klasse hinzu
        overlay.style.position = 'absolute';
        overlay.style.top = element.offsetTop + 'px';
        overlay.style.left = element.offsetLeft + 'px';
        overlay.style.width = element.offsetWidth + 'px';
        overlay.style.height = element.offsetHeight + 'px';
        overlay.style.cursor = 'not-allowed';
        overlay.style.zIndex = '1000';  

        // Fängt Klicks ab und gibt eine Meldung aus
        overlay.addEventListener('click', function() {
            alert(Ossn.Print('user:block:message'));
        });

        // Fügt das Overlay in den gleichen Container wie das Element ein
        element.parentNode.style.position = 'relative'; // Stelle sicher, dass das Eltern-Element relativ positioniert ist
        element.parentNode.appendChild(overlay);

        // Update des Overlays bei Größenänderung des Elements (falls nötig)
        window.addEventListener('resize', function() {
            overlay.style.width = element.offsetWidth + 'px';
            overlay.style.height = element.offsetHeight + 'px';
        });
    }

    function interceptSubmitButton(button) {
        button.addEventListener('click', function(event) {
            event.preventDefault();  // Verhindert das normale Absenden des Formulars
            alert(Ossn.Print('user:block:message'));
        });
    }

    // Überprüfen, ob die aktuelle GUID in der Liste der blockierten Benutzer ist
if (blockedGUIDs.includes(currentUserGUID)) {
    // Selektiere alle Buttons mit der Klasse '.post-control-comment.comment-post' und deaktiviere sie
    var commentButtons = document.querySelectorAll('.post-control-comment.comment-post');
    
    // Iteriere über alle gefundenen Buttons und deaktiviere sie
    commentButtons.forEach(function(commentButton) {
        disableElement(commentButton);
    });

        var commentBoxes = document.querySelectorAll('.comment-box');
        var pinnedCommentBoxes = document.querySelectorAll('.pinned-post .comment-box');
        var submitButton = document.querySelector('.ossn-wall-container input[type="submit"]');

        // Interzeptiert den Submit-Button-Klick im .ossn-wall-container
        if (submitButton) {
            interceptSubmitButton(submitButton);
        }

        // Iteriert über alle .comment-box-Elemente und deaktiviert sie
        commentBoxes.forEach(function(commentBox) {
            disableElement(commentBox);
        });

        // Iteriert über alle .pinned-post .comment-box-Elemente und deaktiviert sie
        pinnedCommentBoxes.forEach(function(pinnedCommentBox) {
            disableElement(pinnedCommentBox);
        });

        // MutationObserver für dynamische Inhalte, wie angepinnte Beiträge und Kommentare
        var observer = new MutationObserver(function(mutationsList) {
            mutationsList.forEach(function(mutation) {
                mutation.addedNodes.forEach(function(node) {
                    if (node.nodeType === 1) {
                        // Sucht nach neuen angepinnten Kommentaren in angezeigten Beiträgen
                        var newPinnedCommentBoxes = node.querySelectorAll('.pinned-post .comment-box');
                        newPinnedCommentBoxes.forEach(function(newPinnedCommentBox) {
                            disableElement(newPinnedCommentBox);
                        });
                    }
                });
            });
        });

        // Überwachen des gesamten Dokument-Body auf Veränderungen
        observer.observe(document.body, { childList: true, subtree: true });
    }
});
