<?php
/**
 * Open Source Social Network
 *
 * @package   Open Source Social Network
 * @author    Open Source Social Network Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */

function com_deactivate_wall_addon_init() {
		// disable Dominik's javascript post-processing of pages completely
		ossn_unextend_view('js/ossn.site', 'js/deactivatewall');

		// mark Dominik's DeactivateWall component as required
		// and prevent deleting/disabling it
		// because this AddOn is based upon it an won't run standalone
		ossn_add_hook('required', 'components', 'com_deactivate_wall_addon_required_components');
	
		if (ossn_isLoggedin()) {
			// use the data of Dominik's component to check if the logged in user is blocked
			$component = new OssnComponents();
			$settings = $component->getSettings('DeactivateWall');
			$blocked_guids = isset($settings->blocked_guids) ? json_decode($settings->blocked_guids) : array();
			if (in_array(ossn_loggedin_user()->guid, $blocked_guids)) {
				// yep this user is part of the blocked list - so ...
				// 1. disable posting
				ossn_add_hook('plugin', 'view:type', 'com_deactivate_wall_addon_disable_posting');
				// 2. disable commenting
				ossn_add_hook('post', 'comments', 'com_deactivate_wall_addon_disable_post_commenting');    
				ossn_add_hook('post', 'comments:entity', 'com_deactivate_wall_addon_disable_entity_commenting');
				// 3. remove the 'Like Comment View all comments etc' menu line
				ossn_add_hook('wall', 'post:menu', 'com_deactivate_wall_addon_remove_postextra_menu_links');
				ossn_register_callback('comment', 'entityextra:menu', 'com_deactivate_wall_addon_remove_entityextra_menu_links');
			}
		}
}

function com_deactivate_wall_addon_required_components($hook, $type, $required, $instance){
	$required[] = 'DeactivateWall'; 
	return $required;
}

function com_deactivate_wall_addon_disable_posting($hook, $type, string $viewtype, array $vars){
	//$viewtype contains previous view type which is `default` 
	//$vars['plugin'] contain the plugin name
	//return 'your view type';

	// check if we're going to display the main newsfeed or the profile newsfeed or a group newsfeed
	if ($vars['plugin'] == 'wall/pages/wall' || $vars['plugin'] == 'wall/user/wall' || $vars['plugin'] == 'wall/group') {
		// if so, don't use the plugins below the path named 'default' anymore
		// but use the customized originals below the plugins/DeactivateWallAddOn/... path
		// ! note that the underlying subdirectory structure and file names need to exactly the same !
		// only the standard 'default' entry point is a different one now - in this case 'DeactivateWallAddOn'
		// that of course must match the directory name you created inside of your component ;)
		return 'DeactivateWallAddOn';
	}
}

function com_deactivate_wall_addon_disable_post_commenting($hook, $type, $return, $params){
	$params['allow_comment'] = false;
	return ossn_plugin_view('comments/post/comments', $params);
}
function com_deactivate_wall_addon_disable_entity_commenting($hook, $type, $return, $params){
	$params['allow_comment'] = false;
	return ossn_plugin_view('comments/post/comments_entity', $params);
}

function com_deactivate_wall_addon_remove_postextra_menu_links($hook, $type, $return, $params) {
	global $Ossn;
	if (isset($Ossn->menu['postextra'])) {
		foreach ($Ossn->menu['postextra'] as $key => $value) {
			ossn_unregister_menu($key, 'postextra');
		}
	}
}

function com_deactivate_wall_addon_remove_entityextra_menu_links($callback, $type, $params) {
	global $Ossn;
	if (isset($Ossn->menu['entityextra'])) {
		foreach ($Ossn->menu['entityextra'] as $key => $value) {
			ossn_unregister_menu($key, 'entityextra');
		}
	}
}

ossn_register_callback('ossn', 'init', 'com_deactivate_wall_addon_init');

