let lastHiddenTime = null;
const updateDelay = 2 * 60 * 1000;

function isPWA() {
    return window.matchMedia('(display-mode: standalone)').matches;
}

document.addEventListener('visibilitychange', () => {
    if (isPWA()) {
        if (document.visibilityState === 'hidden') {
            lastHiddenTime = Date.now();
        } else if (document.visibilityState === 'visible') {
            if (lastHiddenTime && (Date.now() - lastHiddenTime >= updateDelay)) {
                aktualisiereInhalte();
            }
        }
    }
});

function aktualisiereInhalte() {
    window.location.reload();
}
