<?php

define('__SHORT_BIO__', ossn_route()->com . 'ShortBio/');

function com_shortbio_init() {
	// in order to insert/display a short bio on top of the profile page's timewall
	// this component is making use of the hook 
	// ossn_call_hook('profile', 'load:content', $vars, $content);
	// provided by the pagehandler of the OssnProfile component
	ossn_add_hook('profile', 'load:content', 'com_shortbio_bio_box');
}

function com_shortbio_bio_box($hook, $type, $return, $params) {
	// just visit some member pages and log what $params gives
	// error_log('com_shortbio_bio_box $params ' . ossn_dump($params));
	// actually $params['user'] includes all member data of the page we are visiting
	// now let's see what $return gives?
	// error_log('com_shortbio_bio_box $return ' . ossn_dump($return));
	// yeah, that's in fact the complete html of the member's profile page
	// so that's where we want to insert some extra_html in order to display a short bio of that member

	// basically, we could create all that stuff here in place
	// but it's much clearer to code it in a separate file
	// and save that extra code in a variable
	// so ...
	$extra_html = ossn_plugin_view('ShortBio/shortbio-box', $params);

	// now extend the html of $return by inserting the extra_html right before <div class="ossn-profile-wall">
	$extended_html = str_replace('<div class="ossn-profile-wall">', '<div class="shortbio">' . $extra_html . '</div><div class="ossn-profile-wall">', $return);
	// and return it to the pagehandler of the OssnProfile component
	return $extended_html;
}

ossn_register_callback('ossn', 'init', 'com_shortbio_init');
