<script>
    $(document).ready(function () {
        var signuppage = $('#ossn-home-signup');

        if (signuppage.length) {
            function getMobileOperatingSystem() {
                const userAgent = navigator.userAgent || navigator.vendor || window.opera;

                if (/android/i.test(userAgent)) {
                    return "Android";
                }

                if (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream) {
                    return "iOS";
                }

                return "unknown";
            }

            function isInStandaloneMode() {
                return (window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone);
            }

            let deferredPrompt;

            const os = getMobileOperatingSystem();
            if (os === "Android" && !isInStandaloneMode()) {
                window.addEventListener('beforeinstallprompt', (e) => {
                    e.preventDefault();
                    deferredPrompt = e;

                    showInstallPrompt();
                });
            }

            function showInstallPrompt() {
                if (deferredPrompt) {
                    const modal = $(
                        '<div id="pwa-modal" style="position:fixed;top:0;left:0;width:100%;height:100%;background-color:rgba(0,0,0,0.7);z-index:1000;display:flex;justify-content:center;align-items:center;">' +
                        '<div style="background:white;padding:20px;border-radius:10px;text-align:center;">' +
                        '<h2>' + Ossn.Print('install_app') + '</h2>' +
                        '<p>' + Ossn.Print('install_prompt') + '</p>' +
                        '<button id="install-app" style="padding:10px 20px;background-color:blue;color:white;border:none;border-radius:5px;cursor:pointer;">' + Ossn.Print('install') + '</button>' +
                        '<button id="close-modal" style="padding:10px 20px;background-color:gray;color:white;border:none;border-radius:5px;cursor:pointer;margin-left:10px;">' + Ossn.Print('close') + '</button>' +
                        '</div>' +
                        '</div>'
                    );

                    $('body').append(modal);

                    $('#install-app').click(function () {
                        deferredPrompt.prompt();
                        deferredPrompt.userChoice.then((choiceResult) => {
                            deferredPrompt = null;
                        });
                        $('#pwa-modal').remove();
                    });

                    $('#close-modal').click(function () {
                        $('#pwa-modal').remove();
                    });
                } else {
                    showManualInstallInstructions();
                }
            }

            function showManualInstallInstructions() {
                const manualModal = $(
                    '<div id="manual-modal" style="position:fixed;top:0;left:0;width:100%;height:100%;background-color:rgba(0,0,0,0.7);z-index:1000;display:flex;justify-content:center;align-items:center;">' +
                    '<div style="background:white;padding:20px;border-radius:10px;text-align:center;">' +
                    '<h2>' + Ossn.Print('install_app') + '</h2>' +
                    '<p>' + Ossn.Print('manual_install') + '</p>' +
                    '<button id="close-manual-modal" style="padding:10px 20px;background-color:gray;color:white;border:none;border-radius:5px;cursor:pointer;margin-top:10px;">' + Ossn.Print('close') + '</button>' +
                    '</div>' +
                    '</div>'
                );
                $('body').append(manualModal);

                $('#close-manual-modal').click(function () {
                    $('#manual-modal').remove();
                });
            }
        }
    });
</script>
