//<script>
document.addEventListener('DOMContentLoaded', function () {
    function addStatusIndicator() {
        var fullnameElement = document.querySelector('.ossn-profile .user-fullname');
        var verifiedElement = document.querySelector('.ossn-profile .user-fullname .verified-title');

        if (fullnameElement) {
            var statusIndicator = document.createElement('span');
            statusIndicator.className = 'status-indicator';
            statusIndicator.style.backgroundColor = window.profileStatusColor;
            statusIndicator.style.zIndex = '10';

            // Set tooltip for hover on desktop
            statusIndicator.title = window.profileLastOnlineTime;

            // Add touch support with a custom tooltip
            statusIndicator.addEventListener('touchstart', function (event) {
                event.preventDefault(); // Prevent default touch behavior

                // Check if a tooltip already exists, if so, remove it
                var existingTooltip = document.querySelector('.status-tooltip');
                if (existingTooltip) {
                    existingTooltip.remove();
                }

                // Create a tooltip element
                var tooltip = document.createElement('div');
                tooltip.className = 'status-tooltip';
                tooltip.textContent = window.profileLastOnlineTime;
                tooltip.style.position = 'absolute';
                tooltip.style.backgroundColor = 'rgba(0, 0, 0, 0)';
                tooltip.style.color = 'white';
                tooltip.style.padding = '5px 10px';
                tooltip.style.borderRadius = '5px';
                tooltip.style.fontSize = '12px';
                tooltip.style.zIndex = '20';
                tooltip.style.whiteSpace = 'nowrap';
                document.body.appendChild(tooltip);

                // Dynamically position the tooltip
                var rect = statusIndicator.getBoundingClientRect();
                var tooltipRect = tooltip.getBoundingClientRect(); // Get tooltip dimensions
                var viewportWidth = window.innerWidth;

                // Set the initial top position above the indicator
                tooltip.style.top = `${rect.top - tooltipRect.height - 10}px`;

                // Adjust left position to keep the tooltip within the viewport
                if (rect.left + tooltipRect.width > viewportWidth) {
                    tooltip.style.left = `${viewportWidth - tooltipRect.width - 10}px`; // Align to the right edge
                } else if (rect.left < 10) {
                    tooltip.style.left = `10px`; // Align to the left edge
                } else {
                    tooltip.style.left = `${rect.left}px`; // Default left position
                }

                // Remove the tooltip after 3 seconds
                setTimeout(function () {
                    if (tooltip.parentNode) {
                        tooltip.remove();
                    }
                }, 3000);
            });

            if (verifiedElement && !verifiedElement.nextSibling) {
                verifiedElement.parentNode.insertBefore(statusIndicator, verifiedElement.nextSibling);
            } else if (!verifiedElement) {
                var nameStatusWrapper = document.createElement('div');
                nameStatusWrapper.style.display = 'inline-block';
                nameStatusWrapper.style.padding = '5px';
                nameStatusWrapper.style.backgroundColor = 'rgba(0, 0, 0, 0)';
                nameStatusWrapper.style.borderRadius = '5px';

                var fullname = fullnameElement.textContent.trim();
                var nameSpan = document.createElement('span');
                nameSpan.textContent = fullname;
                nameStatusWrapper.appendChild(nameSpan);
                nameStatusWrapper.appendChild(statusIndicator);

                fullnameElement.textContent = '';
                fullnameElement.appendChild(nameStatusWrapper);
            }
        }
    }

    // Call the function once to add the status indicator
    addStatusIndicator();

    // Create a MutationObserver to monitor for changes
    var observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
            // Check if the status indicator was removed, and add it back
            if (mutation.removedNodes.length > 0 || mutation.addedNodes.length > 0) {
                addStatusIndicator();
            }
        });
    });

    // Observe changes in the fullnameElement
    var fullnameElement = document.querySelector('.ossn-profile .user-fullname');
    if (fullnameElement) {
        observer.observe(fullnameElement, { childList: true, subtree: true });
    }
});
