<?php
/**
 * Open Source Social Network
 *
 * @package   Open Source Social Network
 */
ossn_register_callback('ossn', 'init', function () {
    if (ossn_isLoggedin()) {
        ossn_extend_view('css/ossn.default', 'css/OnlineStatus');
        ossn_extend_view('profile/pages/profile', 'online_status');
        ossn_extend_view('js/ossn.site', 'js/OnlineStatus');
    }
});

function is_user_online($last_activity) {
    $online_threshold = 300; // 5 minutes in seconds
    $current_time = time();
    return ($current_time - $last_activity) <= $online_threshold;
}

function online_status() {
    $user = ossn_user_by_guid(ossn_get_page_owner_guid());
	if ($user) {
        $online_status = is_user_online($user->last_activity);
        $status_color = $online_status ? 'green' : 'red';

        // Wenn Nutzer online ist, eine spezielle Nachricht übergeben
        if ($online_status) {
            $formatted_time = ossn_print('online:now'); // Übersetzung für "jetzt online"
        } else {
            // Get the logged-in user's language
            $user_language = ossn_loggedin_user()->language;

            // Format time and date based on user language
            if ($user_language === 'de') {
                $date = strftime('%d.%m.%Y', $user->last_activity); // German date format
                $time = strftime('%H:%M', $user->last_activity);    // 24-hour format
            } else {
                $date = strftime('%B %d, %Y', $user->last_activity); // English date format
                $time = strftime('%I:%M %p', $user->last_activity);  // 12-hour format with AM/PM
            }

            // Format using translations
            $formatted_time = ossn_print('last:online:time', array($date, $time));
        }

        // Pass the status color and formatted time to JavaScript
        return "<script>
            window.profileStatusColor = '{$status_color}';
            window.profileLastOnlineTime = '" . $formatted_time . "';
        </script>";
    }
}