<?php

define('__ONLINE_STATUS_SYNC__', ossn_route()->com . 'OnlineStatusSync/');

function com_online_status_sync_init() {
	if (ossn_isLoggedin()) {
		// this hook gets called on every page load
		// see ossn_load_page() in libraries/ossn.lib.page.php
		ossn_add_hook('page', 'load', 'com_online_status_sync_extend_bootchat_xhr');
	}
}

function com_online_status_sync_extend_bootchat_xhr($hook, $type, $return, $params) {
	// this time we're interested to fetch and extend OssnChats' Javascript named 'ossn.boot.chat.js'
	// loaded in regular intervals as Ajax XHR
	if (isset($params['page'][1]) && $params['page'][1] == 'ossn.boot.chat.js' ) {
		// ok - script just loaded
		// next, retrieve the member's name from the page url we're curently visiting
		// we can't use Ossn's current_url() here, since we are just fetching 'ossn.boot.chat.js' :)
		// but ...
		if (isset($_SERVER['HTTP_REFERER']) && !empty($_SERVER['HTTP_REFERER'])) {
			// we can retrieve the name this way
			$current_path = parse_url($_SERVER['HTTP_REFERER'], PHP_URL_PATH);
			// error_log('current_path: ' . $current_path);
			$is_user_page = preg_match('/\/u\//', $current_path);
			if ($is_user_page) {
				$path_elements = explode('/', $current_path);
				//error_log(ossn_dump($path_elements));
				$username = false;
				foreach ($path_elements as $index => $element) {
					// error_log ($index . ' ' . $element);
					if ($element == 'u' && isset($path_elements[$index + 1]) && !empty($path_elements[$index + 1])) {
						// found /u/ so the next path element should be the username
						$username = $path_elements[$index + 1];
						break;
					}
				}
				if ($username) {
					$user = ossn_user_by_username($username);
					// check for manually entered non existing user
					if ($user) {
						// existing, so finally create the script to update colors
						if ($user->isOnline(10)) { // <-- use same param as OssnChat to be in sync
							// EighteenMale component support
							$status_refresh = '$(".ossn-profile .profile-photo").css({"padding":"0px","border-width":"2px","border-color":"#4cae4c"});';
							$status_refresh .= '$(".ossn-profile .profile-photo img").css({"padding":"0px","border-width":"2px","border-color":"#4cae4c"});';
							// OnlineStatus component support
							$status_refresh .= '$(".status-indicator").css({"background-color":"#4cae4c"});';
							$return .= $status_refresh;
						} else {
							$status_refresh = '$(".ossn-profile .profile-photo").css({"padding":"0px","border-width":"2px","border-color":"#ec2828"});';
							$status_refresh .= '$(".ossn-profile .profile-photo img").css({"padding":"0px","border-width":"2px","border-color":"#ec2828"});';
							$status_refresh .= '$(".status-indicator").css({"background-color":"#ec2828"});';
							$return .= $status_refresh;
						}
						// and append it to ossn.boot.chat.js XHR
						return $return;
					}
				}
			}
		}
	}
}

ossn_register_callback('ossn', 'init', 'com_online_status_sync_init');
