<?php

define('__GOBLUE_REGISTRATION_PAGE__', ossn_route()->com . 'GoblueRegistrationPage/');

function com_goblueregistrationpage_init() {
		// register a new page which is callable via https://YOURSITE/register
		// and add a pagehandler for that page
		ossn_register_page('register', 'com_goblueregistrationpage_page_handler');

		// dev7: unregister the default core login action
		ossn_unregister_action('user/login');
		// and replace it by our own custom action
		ossn_register_action('user/login', __GOBLUE_REGISTRATION_PAGE__ . 'actions/GoblueRegistrationPageLogin.php');
		// add "Sign Up" page to be accepted by the Private Network component
		ossn_add_hook('private:network', 'allowed:pages', 'com_goblueregistrationpage_extend_allowed_pages');
}

function com_goblueregistrationpage_page_handler($page) {
	if (empty($page) || ossn_isLoggedin()) {
		// don't make the register page available for already logged in members 
		redirect(REF);
	}
	// browser tab title
	$title = ossn_print('create:account');
	// retrieve the content to be displayed from this component's file plugins/default/pages/registration-page.php
	$contents = array('content' => ossn_plugin_view('pages/registration-page'));
	// define a page layout to put the content onto 
	// see themes/goblue/plugins/default/theme/page/layout for other options
	$content = ossn_set_page_layout('startup', $contents);
	// display the complete page
	echo ossn_view_page($title, $content);			
}

// dev7
// add our registered custom Sign Up page to Private Network exceptions
function com_goblueregistrationpage_extend_allowed_pages($hook, $type, $allowed_pages, $params) {
    $allowed_pages[0][] = 'register';    // pages to be addressed by 1 path element
    return $allowed_pages;
}

ossn_register_callback('ossn', 'init', 'com_goblueregistrationpage_init');
