<?php
/**
 * Open Source Social Network
 *
 * @package   (openteknik.com).ossn
 * @author    OSSN Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */
// dev8
// take care of custom logos introduced with Ossn 7.3
$custom_settings = ossn_goblue_get_custom_logos_bgs_setting(); 
?>
<div class="row ossn-page-contents justify-content-center g-0">
		<div class="col-md-6 home-left-contents">
			<div class="logo">
			<?php if(isset($custom_settings) && isset($custom_settings['logo_site'])){ ?>
            		<img src="<?php echo ossn_add_cache_to_url(ossn_theme_url("logos_backgrounds/logo_site_{$custom_settings['logo_site']}"));?>" />
            <?php } else { ?>
            		<img src="<?php echo ossn_theme_url();?>images/logo.png" />                
            <?php } ?>
            </div>	
            <div class="description">
            	<?php echo ossn_print('home:top:heading', array(ossn_site_settings('site_name'))); ?>
            </div>

			<?php 
			/*
			dev7: no longer needed because error messages are issued by the action now
			$error = input('error');
			if ($error == 1) {
		        <div class="alert alert-danger">
		            <strong><?php echo ossn_print('login:error'); ?></strong><br/>
			        <p><?php echo ossn_print('login:error:sub'); ?></p>
		        </div>
			}
			*/
			$contents = ossn_view_form('GoblueRegistrationPageLogin', array(
            		'id' => 'ossn-login',
           			'action' => ossn_site_url('action/user/login'),
        	));
			?>
			<div class="ossn-widget">
				<div class="widget-contents">
					<?php
						echo $contents;
					?>
				</div>
			</div>
 		</div>   
</div>	
