<?php
/**
 * OSSN Component: FediverseBridge
 * 🇳🇱 Dutch language file
 * Made by Eric Redegeld for nlsociaal.nl
 */

ossn_register_languages('en', array(
    // Admin menu
    'fediversebridge:optinusers' => 'Fediverse Opt-in Users',
    'fediversebridge:adminmenu' => 'Fediverse Opt-in Users',
    'fediversebridge:admin:optinusers:title' => 'Fediverse Opt-in Users',
    'fediversebridge:admin:optinusers:nousers' => 'There are currently no users with Fediverse opt-in.',
    'fediversebridge:admin:optinusers:view' => 'View profile',

    // Profile opt-in page
    'fediversebridge:menu:optin' => 'Fediverse',
    'fediversebridge:optin:profile:title' => 'Fediverse Opt-in',
    'fediversebridge:optin:profile:enabled' => '✅ You are currently participating in the Fediverse.',
    'fediversebridge:optin:profile:disabled' => '❌ You have disabled Fediverse integration.',
    'fediversebridge:optin:profile:checkbox' => 'I want to participate in the Fediverse',
    'fediversebridge:optin:profile:save' => 'Save',
    'fediversebridge:optin:profile:sharetip' => 'Share this address so others can follow you via Mastodon or other Fediverse platforms.',
    'fediversebridge:optin:profile:enablebtn' => '✅ Enable',
    'fediversebridge:optin:profile:disablebtn' => '❌ Disable',
    'fediversebridge:optin:profile:findable' => 'Discoverable on the Fediverse',

    // Interactions
    'fediversebridge:likes:title' => '❤️ Likes Received',
    'fediversebridge:like:by' => '❤️ by %s on %s (%s)',
    'fediversebridge:announces:title' => '🔁 Shared Posts (Announce)',
    'fediversebridge:announce:by' => '🔁 by %s of <a href="%s" target="_blank">%s</a> (%s)',
    'fediversebridge:replies:title' => '💬 Replies Received',
    'fediversebridge:reply:by' => '💬 by %s (%s)',
    'fediversebridge:reply:inreplyto' => 'Reply to',
    'fediversebridge:ownreplies:title' => '🧵 Replies to Your Posts',
    'fediversebridge:followers:title' => '👥 Followers',

    // Threads
    'fediversebridge:thread:title' => '🧵 Thread for post %s',
    'fediversebridge:thread:collapse' => '➖ Hide thread',
    'fediversebridge:thread:expand' => '➕ Show thread',

    // Blocking actors
    'fediversebridge:optin:block:btn' => 'Block',
    'fediversebridge:optin:block:placeholder' => 'actor URI (e.g. https://...)',
    'fediversebridge:optin:block:title' => '🚫 Block a specific actor',
    'fediversebridge:optin:block:success' => '🔒 Actor blocked: %s',

    // Feedback messages
    'fediversebridge:optin:profile:success' => '✅ Fediverse opt-in is enabled for %s.',
    'fediversebridge:optin:profile:error' => '❌ Fediverse opt-in is disabled for %s.',
    'fediversebridge:nousers' => 'No users have enabled opt-in.',

    // Debug info
    'fediversebridge:debug:title' => '[DEBUG]',
    'fediversebridge:debug:username' => 'User: %s',
    'fediversebridge:debug:privatekey' => 'Private key: %s',
    'fediversebridge:debug:publickey' => 'Public key: %s',
    'fediversebridge:debug:outbox' => 'Outbox dir: %s',
    'fediversebridge:debug:optinfile' => 'Opt-in JSON: %s',
    'fediversebridge:debug:userguid' => 'User GUID: %s',

    // Errors
    'fediversebridge:error:usernotfound' => 'User not found.',
    'fediversebridge:error:pageinvalid' => 'Invalid Fediverse page.',

    // Activation/install logs
    'fediversebridge:enable:log:dir:created' => '📁 Directory created: %s',
    'fediversebridge:enable:log:dir:failed' => '❌ Failed to create directory: %s',
    'fediversebridge:enable:log:key:priv:created' => '🔑 Private key created: %s.pem',
    'fediversebridge:enable:log:key:pub:created' => '🔓 Public key created: %s.pubkey',
    'fediversebridge:enable:log:key:pub:failed' => '⚠️ Warning: public key not extracted for %s',
    'fediversebridge:enable:log:key:gen:failed' => '❌ Failed to generate OpenSSL key for %s',
    'fediversebridge:enable:log:optin:created' => '✅ Opt-in file created for %s',
    'fediversebridge:enable:log:outbox:test' => '📤 Test message saved to: %s',
    'fediversebridge:enable:log:install:done' => '✅ INSTALLATION: FediverseBridge activated successfully',
    'fediversebridge:enable:testmessage' => 'Test message from enable.php (user: %s)<br /><a href="%s" target="_blank">%s</a>',

    // Inbox
    'fediversebridge:inbox:error:nouser' => '❌ No username provided',
    'fediversebridge:inbox:error:method' => '❌ Only POST requests are allowed',
    'fediversebridge:inbox:error:contenttype' => '🚫 INBOX: Invalid Content-Type: %s',
    'fediversebridge:inbox:error:body' => '❌ Empty or invalid body',
    'fediversebridge:inbox:error:json' => '❌ Failed to parse JSON',
    'fediversebridge:inbox:error:signature' => '🚫 Invalid signature for %s',
    'fediversebridge:inbox:ignored' => '⛔️ Actor %s is not a known follower of %s, message ignored.',
    'fediversebridge:inbox:received' => '📥 INBOX received for %s | Type: %s',
    'fediversebridge:inbox:stored' => '📩 Message stored at %s',
    'fediversebridge:inbox:like' => '❤️ Like received from %s on %s',
    'fediversebridge:inbox:announce' => '🔁 Announce received from %s on %s',
    'fediversebridge:inbox:create' => '🆕 Create (Note) received from %s',
    'fediversebridge:inbox:create:reply' => '📝 Reply saved for post %s in %s',
    'fediversebridge:inbox:create:noguid' => '⚠️ No GUID found in inReplyTo: %s',
    'fediversebridge:inbox:create:skip' => '⏭️ Create is not a reply to a local post, skipped.',
    'fediversebridge:inbox:follow' => '👤 New follower: %s',
    'fediversebridge:inbox:follow:added' => '✅ Follower added to %s',
    'fediversebridge:inbox:undo' => '↩️ Undo %s by %s for %s',

    // Actor profile
    'fediversebridge:actor:error:missing' => '❌ Missing username',
    'fediversebridge:actor:error:notfound' => '❌ User not found',
    'fediversebridge:actor:error:nopubkey' => '❌ Public key missing',
    'fediversebridge:actor:summary' => 'User of %2$s (@%1$s)',

    // Avatar and media
    'fediversebridge:avatar:error:badrequest' => '❌ Invalid request',
    'fediversebridge:avatar:error:missing' => '❌ Invalid request (missing GUID or filename)',
    'fediversebridge:avatar:error:notfound' => '❌ Avatar not found',
    'fediversebridge:avatar:error:missing_data' => 'Invalid avatar request: missing data.',
    'fediversebridge:avatar:error:notfound_user' => 'No avatar found for this user.',
    'fediversebridge:proxy:error:missing' => '❌ Invalid request (missing GUID or filename)',
    'fediversebridge:proxy:error:invalidobj' => '❌ Object not found or invalid',
    'fediversebridge:proxy:error:filenotfound' => '❌ File not found',
    'fediversebridge:proxy:log:show' => '🖼️ Showing %s (%s, %s bytes) from object %s',

    // Federated note view
    'fediversebridge:note:log:visit' => 'note.php visited: username=%s, guid=%s',
    'fediversebridge:note:error:invalid' => '❌ Invalid request format',
    'fediversebridge:note:error:user' => '❌ User not found',
    'fediversebridge:note:error:post' => '❌ Post not found',
    'fediversebridge:note:error:mismatch' => '❌ Post does not belong to this user',
    'fediversebridge:note:viewlink' => 'View on %s',

    // Followers endpoint
    'fediversebridge:followers:error:missing' => '❌ Missing username',
    'fediversebridge:followers:error:notfound' => '❌ User not found',
    'fediversebridge:log:nofollowersfile' => 'No followers.json for %s, using fallback inboxes.',
    'fediversebridge:log:invalidfollowersfile' => 'Invalid or corrupted followers.json for %s.',
    'fediversebridge:log:nooptinfile' => 'No opt-in file for %s, post not federated.',

    // Sign logs
    'fediversebridge:log:key:missing' => 'Private key not found for %s: %s',
    'fediversebridge:log:inbox:invalid' => 'Invalid inbox URL: %s',
    'fediversebridge:log:openssl:loadfail' => 'OpenSSL could not load key for %s',
    'fediversebridge:log:openssl:signfail' => 'Signing failed for %s. OpenSSL error: %s',
    'fediversebridge:log:accept:start' => 'Sending Accept activity to %s for %s',
    'fediversebridge:log:accept:headersfail' => 'Could not generate headers for Accept to %s',
    'fediversebridge:log:accept:curlfail' => 'cURL error sending Accept to %s: %s',
    'fediversebridge:log:accept:success' => 'Accept sent to %s. HTTP status: %s. Response: %s',

    // Profile handler UI
    'fediversebridge:profile:header' => ' Fediverse Handler Info',
    'fediversebridge:profile:actorurl' => 'Actor URL',
    'fediversebridge:profile:webfinger' => 'WebFinger',

    // URL check tool
    'fediversebridge:check:title' => 'Inspect External Fediverse Post',
    'fediversebridge:check:btn' => 'Inspect URL',
    'fediversebridge:check:trying' => 'Trying to fetch ActivityPub data...',
    'fediversebridge:check:fail' => 'Failed to fetch the URL.',
    'fediversebridge:check:invalidjson' => 'Could not parse valid JSON.',
    'fediversebridge:check:success' => 'Message retrieved successfully!'
));
