<?php
header('Content-Type: application/json');

$user = array();
$user['username']  = input('username');
$user['firstname'] = input('firstname');
$user['lastname']  = input('lastname');
$user['email']     = input('email');
$user['reemail']   = input('email_re');
$user['password']  = input('password');

foreach ($user as $v) {
    if (empty($v)) {
        echo json_encode(array('error' => '1'));
        exit;
    }
}

if ($user['reemail'] !== $user['email']) {
    echo json_encode(array('dataerr' => ossn_print('email:error:matching')));
    exit;
}

// If GDPR component is enabled, require its checkbox
if (function_exists('ossn_isActiveComponent') && ossn_isActiveComponent('GDPR')) {
    if (!input('gdpr_agree')) {
        echo json_encode(array('dataerr' => ossn_print('gdpr:signup:error')));
        exit;
    }
}

$add = new OssnUser;
$add->username        = $user['username'];
$add->first_name      = $user['firstname'];
$add->last_name       = $user['lastname'];
$add->email           = $user['email'];
$add->password        = $user['password'];
$add->sendactiviation = true;
$add->validated       = false;

if (!$add->isUsername()) {
    echo json_encode(array('dataerr' => ossn_print('username:error')));
    exit;
}
if (!$add->isPassword()) {
    echo json_encode(array('dataerr' => ossn_print('password:error')));
    exit;
}
if ($add->isOssnUsername()) {
    echo json_encode(array('dataerr' => ossn_print('username:inuse')));
    exit;
}
if ($add->isOssnEmail()) {
    echo json_encode(array('dataerr' => ossn_print('email:inuse')));
    exit;
}
if (!$add->isEmail()) {
    echo json_encode(array('dataerr' => ossn_print('email:invalid')));
    exit;
}

if ($add->addUser()) {
    echo json_encode(array('success' => 1, 'datasuccess' => ossn_print('account:created:email')));
    exit;
}

echo json_encode(array('dataerr' => ossn_print('account:create:error:admin')));
exit;
