<?php
/**
 * Open Source Social Network
 *
 * @package   Open Source Social Network (OSSN)
 * @author    OSSN Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */
class PrivateGroup extends OssnObject {
		/**
		 * Initialize the object.
		 *
		 * @return void;
		 */
		public function initAttributes() {
				$this->OssnDatabase = new OssnDatabase();
				$this->OssnFile     = new OssnFile();
		}

		/**
		 * Create group
		 *
		 * @params $params['name'] Name of group
		 *         $params['description'] Group description
		 *         $params['owner_guid']: Guid of owner creating group
		 *         $params['privacy'] Group Privacy
		 *
		 * @return bool;
		 */
		public function createGroup($params) {
				self::initAttributes();
				$this->title       = trim($params['name']);
				$this->description = trim($params['description']);
				if(empty($this->title) || ($params['privacy'] != OSSN_PRIVATE && $params['privacy'] != OSSN_PUBLIC && $params['privacy'] != OSSN_FRIENDS)) {
						return false;
				}
				$this->owner_guid       = $params['owner_guid'];
				$this->type             = 'user';
				$this->subtype          = 'ossngroup';
				$this->data->membership = $params['privacy'];
				if($guid = $this->addObject()) {
						ossn_add_relation($params['owner_guid'], $this->getGuid(), 'group:join');
						ossn_add_relation($this->getGuid(), $params['owner_guid'], 'group:join:approve');

						ossn_trigger_callback('group', 'add', array(
								'group_guid' => $guid,
						));
						return true;
				}
				return false;
		}

		/**
		 * Get guid of newly created group
		 *
		 * @return int;
		 * @access public;
		 */
		public function getGuid() {
				return $this->getObjectId();
		}

} //class