<?php
/**
 * Open Source Social Network
 * @link      https://www.opensource-socialnetwork.org/
 * @package   Private Groups
 * @author    Michael Zülsdorff <ossn@z-mans.net>
 * @copyright (C) Michael Zülsdorff
 * @license   GNU General Public License https://www.gnu.de/documents/gpl-2.0.en.html
 */

define('__PRIVATE_GROUPS__', ossn_route()->com . 'PrivateGroups/');

/* Include changed group class */
require_once __PRIVATE_GROUPS__ . 'classes/PrivateGroup.php';

function com_private_groups_init()
{
	ossn_add_hook('required', 'components', 'com_private_groups_asure_requirements');

	if (! ossn_isLoggedin() || (ossn_isLoggedin() && !ossn_isAdminLoggedin())) {
		// prevent the listing of private groups on Search
		ossn_unset_hook('search', 'type:groups', 'groups_search_handler');
		ossn_add_hook('search', 'type:groups', 'com_private_groups_groups_search_handler');
	}

	if (ossn_isLoggedin()) {
		// change group original actions to include private groups
		ossn_unregister_action('group/add');
		ossn_register_action('group/add', __PRIVATE_GROUPS__ . 'actions/group/add.php');
		ossn_unregister_action('group/edit');
		ossn_register_action('group/edit', __PRIVATE_GROUPS__ . 'actions/group/edit.php');

		// enhance GroupIvite to work on mobile devices
		ossn_new_external_js('jquery.tokeninput', 'vendors/jquery/jquery.tokeninput.js');
		ossn_load_external_js('jquery.tokeninput');
		ossn_group_subpage('invite');
		ossn_add_hook('group', 'subpage', 'com_private_groups_invite_page');
		ossn_register_callback('page', 'load:group', 'com_private_groups_group_load_event');
	}
}

// private group functions -----------------------------------------------
function com_private_groups_groups_search_handler($hook, $type, $return, $params)
{
	$groups = new OssnGroup();
	$data   = $groups->searchGroups($params['q'], array(
			'entities_pairs' => array(
				array(
					'name'   => 'membership',
					'wheres' => OssnDatabase::wheres('emd0.value', '!=', '3'),
					'value'  => true,
				),
			),
	));
	$count  = $groups->searchGroups($params['q'], array(
			'count' => true,
			'entities_pairs' => array(
				array(
						'name'   => 'membership',
						'wheres' => OssnDatabase::wheres('emd0.value', '!=', '3'),
						'value'  => true,
				),
			),
	));

	$group['groups'] = $data;
	$search          = ossn_plugin_view('groups/search/view', $group);
	$search .= ossn_view_pagination($count);
	if(empty($data)) {
			return ossn_print('ossn:search:no:result');
	}
	return $search;
}

function com_private_groups_got_invitation($from_group)
{
	if (ossn_isLoggedin()) {
		$notification = new OssnNotifications();
		$been_invited = $notification->searchNotifications(array(
			'type'         => 'groupinvite',
			'subject_guid' => $from_group,
			'owner_guid'   => ossn_loggedin_user()->guid,
			)
		);
		return $been_invited || ossn_isAdminLoggedin();
	}
	return false;
}

// GroupInvite mobile view enhancement functions -------------------------
function com_private_groups_group_load_event($event, $type, $params)
{
	if (ossn_isLoggedin() && $params['group']->isMember(null, ossn_loggedin_user()->guid)) {
		ossn_register_menu_link('invite', 'groupinvite:invite', ossn_group_url($params['group']->guid) . 'invite', 'groupheader');
	}
}

function com_private_groups_invite_page($hook, $type, $return, $params)
{
	if ($params['subpage'] == 'invite') {
		if (ossn_isLoggedin() && $params['group']->isMember(null, ossn_loggedin_user()->guid)) {
			$mod_content = ossn_plugin_view('groupinvite/widget', $params);
			$mod         = array(
					'title'   => '',
					'content' => $mod_content,
			);
			echo ossn_set_page_layout('module', $mod);
		}
	}
}

// helper functions -----------------------------------------------------
function com_private_groups_asure_requirements($hook, $type, $return, $params)
{
	$return[] = 'OssnGroups';
	$return[] = 'GroupInvite';
	return $return;
}

ossn_register_callback('ossn', 'init', 'com_private_groups_init');
