<?php
/**
 * Analytics Action Handler
 * Handles analytics and reporting requests
 */

if(ossn_isLoggedin()) {
    $user_id = ossn_loggedin_user()->guid;
    $analytics_action = $_POST['report_type'] ?? 'usage';
    $period = $_POST['period'] ?? 'month';
    
    try {
        $analytics = new AIAnalytics($user_id);
        
        switch($analytics_action) {
            case 'usage':
                $result = $analytics->getUsageStats($period);
                break;
                
            case 'features':
                $result = ['features' => $analytics->getFeatureUsage($period)];
                break;
                
            case 'sentiment':
                $result = ['sentiment' => $analytics->getSentimentTrends($period)];
                break;
                
            case 'recommendations':
                $result = ['metrics' => $analytics->getRecommendationMetrics()];
                break;
                
            case 'performance':
                $result = ['performance' => $analytics->getPerformanceMetrics()];
                break;
                
            case 'trending':
                $result = ['trending' => $analytics->getTrendingTopics(10)];
                break;
                
            case 'full_report':
                $result = $analytics->generateReport($period);
                break;
                
            case 'export':
                header('Content-Type: application/json');
                header('Content-Disposition: attachment; filename="alkebulan_report_' . date('Y-m-d') . '.json"');
                echo $analytics->exportReport($period);
                exit;
                
            default:
                $result = $analytics->getUsageStats($period);
        }
        
        echo json_encode([
            'success' => true,
            'data' => $result,
            'period' => $period,
            'report_type' => $analytics_action,
            'generated_at' => time()
        ]);
        
    } catch(Exception $e) {
        echo json_encode([
            'success' => false,
            'error' => $e->getMessage()
        ]);
    }
} else {
    echo json_encode(['error' => 'Not logged in', 'success' => false]);
}
?>
