<?php
/**
 * Alkebulan AI Language Strings - English
 * Complete localization for all component pages
 */

$en = array(
    // Component Names
    'alkebulan:component' => 'Alkebulan AI',
    'alkebulan:component:desc' => 'Advanced AI-powered analytics and insights for your social network',
    
    // Dashboard
    'alkebulan:dashboard' => 'Dashboard',
    'alkebulan:dashboard:desc' => 'Overview of your AI features and usage',
    'alkebulan:dashboard:title' => 'Alkebulan AI Dashboard',
    'alkebulan:dashboard:subtitle' => 'Advanced AI-Powered Analytics & Insights',
    'alkebulan:dashboard:features' => 'AI Features',
    'alkebulan:dashboard:activity' => 'Recent Activity',
    'alkebulan:dashboard:actions' => 'Quick Actions',
    'alkebulan:dashboard:usage' => 'Usage This Month',
    'alkebulan:dashboard:view_all' => 'View All',
    'alkebulan:dashboard:view_more' => 'View More',
    
    // Metrics
    'alkebulan:metric:analyses' => 'Total Analyses',
    'alkebulan:metric:recommendations' => 'Recommendations',
    'alkebulan:metric:sessions' => 'Chat Sessions',
    'alkebulan:metric:response' => 'Avg Response',
    'alkebulan:metric:calls' => 'API Calls',
    'alkebulan:metric:tokens' => 'Tokens Used',
    'alkebulan:metric:storage' => 'Storage Used',
    
    // Features Page
    'alkebulan:features' => 'Features',
    'alkebulan:features:hero' => '✨ Alkebulan AI Features',
    'alkebulan:features:subtitle' => 'Powerful AI-driven capabilities for your social network',
    
    // Analysis Feature
    'alkebulan:feature:analysis' => 'Intelligent Content Analysis',
    'alkebulan:feature:analysis:desc' => 'Automatically analyze your content with advanced AI algorithms',
    'alkebulan:feature:sentiment' => 'Sentiment Analysis',
    'alkebulan:feature:sentiment:desc' => 'Detect positive, negative, and neutral sentiments',
    'alkebulan:feature:emotion' => 'Emotion Recognition',
    'alkebulan:feature:emotion:desc' => 'Identify emotions like happiness, sadness, anger',
    'alkebulan:feature:entities' => 'Entity Recognition',
    'alkebulan:feature:entities:desc' => 'Extract persons, places, and organizations',
    'alkebulan:feature:keywords' => 'Keyword Extraction',
    'alkebulan:feature:keywords:desc' => 'Discover important keywords and topics',
    'alkebulan:feature:categorize' => 'Content Categorization',
    'alkebulan:feature:categorize:desc' => 'Auto-categorize into tech, business, health, etc.',
    
    // Recommendations Feature
    'alkebulan:feature:recommendations' => 'Smart Recommendations',
    'alkebulan:feature:recommendations:desc' => 'Get personalized recommendations based on your interests',
    'alkebulan:feature:content_rec' => 'Content Recommendations',
    'alkebulan:feature:content_rec:desc' => 'Discover relevant posts and articles',
    'alkebulan:feature:people_rec' => 'People Suggestions',
    'alkebulan:feature:people_rec:desc' => 'Find interesting users to follow',
    'alkebulan:feature:group_rec' => 'Community Discovery',
    'alkebulan:feature:group_rec:desc' => 'Join groups that match your interests',
    'alkebulan:feature:trending' => 'Trending Topics',
    'alkebulan:feature:trending:desc' => 'Stay updated with what\'s trending',
    'alkebulan:feature:feed' => 'Timeline Feed',
    'alkebulan:feature:feed:desc' => 'Personalized content feed powered by AI',
    
    // Chat Feature
    'alkebulan:feature:chat' => 'AI Chat Assistant',
    'alkebulan:feature:chat:desc' => 'Chat with our intelligent assistant for instant help',
    'alkebulan:feature:conversation' => 'Conversational AI',
    'alkebulan:feature:conversation:desc' => 'Natural language conversations',
    'alkebulan:feature:intent' => 'Intent Detection',
    'alkebulan:feature:intent:desc' => 'Understanding what you\'re asking',
    'alkebulan:feature:context' => 'Context Awareness',
    'alkebulan:feature:context:desc' => 'Remembers conversation context',
    'alkebulan:feature:suggestions' => 'Smart Suggestions',
    'alkebulan:feature:suggestions:desc' => 'Get suggestions for next steps',
    'alkebulan:feature:summary' => 'Session Summaries',
    'alkebulan:feature:summary:desc' => 'Automatic conversation summaries',
    
    // Analytics Feature
    'alkebulan:feature:analytics' => 'Advanced Analytics',
    'alkebulan:feature:analytics:desc' => 'Get detailed insights into your AI usage and performance',
    'alkebulan:feature:usage' => 'Usage Statistics',
    'alkebulan:feature:usage:desc' => 'Track API calls and token usage',
    'alkebulan:feature:performance' => 'Performance Metrics',
    'alkebulan:feature:performance:desc' => 'Monitor response times and speed',
    'alkebulan:feature:trends' => 'Trending Topics',
    'alkebulan:feature:trends:desc' => 'See what\'s trending in your content',
    'alkebulan:feature:sentiment_trends' => 'Sentiment Trends',
    'alkebulan:feature:sentiment_trends:desc' => 'Track sentiment patterns over time',
    'alkebulan:feature:reports' => 'Report Generation',
    'alkebulan:feature:reports:desc' => 'Create comprehensive reports',
    
    // Chat Page
    'alkebulan:chat' => 'Chat Assistant',
    'alkebulan:chat:title' => 'AI Chat Assistant',
    'alkebulan:chat:subtitle' => 'Chat with Alkebulan AI for insights and assistance',
    'alkebulan:chat:sessions' => 'Sessions',
    'alkebulan:chat:new' => 'New Session',
    'alkebulan:chat:clear' => 'Clear Chat',
    'alkebulan:chat:export' => 'Export',
    'alkebulan:chat:placeholder' => 'Ask me anything...',
    'alkebulan:chat:duration' => 'Duration',
    'alkebulan:chat:messages' => 'Messages',
    'alkebulan:chat:topics' => 'Topics',
    'alkebulan:chat:context' => 'Context',
    'alkebulan:chat:suggestions' => 'Suggestions',
    'alkebulan:chat:start' => 'Start Chat',
    'alkebulan:chat:quick_prompts' => 'Quick Prompts',
    
    // Analytics Page
    'alkebulan:analytics' => 'Analytics',
    'alkebulan:analytics:title' => 'Alkebulan AI Analytics',
    'alkebulan:analytics:subtitle' => 'Track your AI usage, performance, and insights',
    'alkebulan:analytics:metrics' => 'Key Metrics',
    'alkebulan:analytics:usage' => 'Usage by Feature',
    'alkebulan:analytics:sentiment' => 'Sentiment Trends',
    'alkebulan:analytics:performance' => 'Performance Metrics',
    'alkebulan:analytics:entities' => 'Top Entities Mentioned',
    'alkebulan:analytics:cost' => 'Cost Analysis',
    'alkebulan:analytics:timeline' => 'Usage Timeline',
    'alkebulan:analytics:report' => 'Detailed Report',
    'alkebulan:analytics:today' => 'Today',
    'alkebulan:analytics:week' => 'Week',
    'alkebulan:analytics:month' => 'Month',
    'alkebulan:analytics:year' => 'Year',
    'alkebulan:analytics:generate' => 'Generate Report',
    'alkebulan:analytics:export' => 'Export CSV',
    'alkebulan:analytics:summary' => 'Summary',
    'alkebulan:analytics:details' => 'Details',
    'alkebulan:analytics:comparison' => 'Comparison',
    
    // Statistics
    'alkebulan:stat:positive' => 'Positive',
    'alkebulan:stat:neutral' => 'Neutral',
    'alkebulan:stat:negative' => 'Negative',
    'alkebulan:stat:min' => 'Min',
    'alkebulan:stat:avg' => 'Avg',
    'alkebulan:stat:max' => 'Max',
    'alkebulan:stat:response_time' => 'Response Time',
    'alkebulan:stat:tokens' => 'Tokens',
    'alkebulan:stat:calls' => 'API Calls',
    
    // Settings Page
    'alkebulan:settings' => 'Settings',
    'alkebulan:settings:title' => 'Alkebulan AI Settings',
    'alkebulan:settings:subtitle' => 'Configure your AI preferences and manage your account',
    'alkebulan:settings:general' => 'General Settings',
    'alkebulan:settings:preferences' => 'Preferences',
    'alkebulan:settings:privacy' => 'Privacy & Security',
    'alkebulan:settings:api' => 'API Configuration',
    'alkebulan:settings:notifications' => 'Notifications',
    'alkebulan:settings:about' => 'About',
    'alkebulan:settings:language' => 'Language',
    'alkebulan:settings:theme' => 'Theme',
    'alkebulan:settings:autosave' => 'Auto-save Settings',
    'alkebulan:settings:analysis_type' => 'Default Analysis Type',
    'alkebulan:settings:sensitivity' => 'Recommendation Sensitivity',
    'alkebulan:settings:chat_style' => 'Chat Response Style',
    'alkebulan:settings:tracking' => 'Enable Analytics Tracking',
    'alkebulan:settings:batch' => 'Batch Processing',
    'alkebulan:settings:privacy_data' => 'Data Privacy',
    'alkebulan:settings:history' => 'Chat History Storage',
    'alkebulan:settings:encryption' => 'Analysis Data Encryption',
    'alkebulan:settings:export' => 'Export Personal Data',
    'alkebulan:settings:delete' => 'Delete All Data',
    'alkebulan:settings:api_key' => 'API Key',
    'alkebulan:settings:rate_limit' => 'API Rate Limit',
    'alkebulan:settings:quota' => 'Daily API Quota',
    'alkebulan:settings:domains' => 'Allowed Domains',
    'alkebulan:settings:regenerate' => 'Regenerate API Key',
    'alkebulan:settings:usage_alerts' => 'Usage Alerts',
    'alkebulan:settings:updates' => 'System Updates',
    'alkebulan:settings:weekly' => 'Weekly Reports',
    'alkebulan:settings:email' => 'Email Notifications',
    'alkebulan:settings:email_address' => 'Notification Email',
    'alkebulan:settings:save' => 'Save Changes',
    'alkebulan:settings:reset' => 'Reset to Defaults',
    
    // Actions
    'alkebulan:action:analyze' => 'Analyze Text',
    'alkebulan:action:analyze_now' => 'Analyze Now',
    'alkebulan:action:recommendations' => 'Get Recommendations',
    'alkebulan:action:start_chat' => 'Start Chat',
    'alkebulan:action:view_analytics' => 'View Analytics',
    'alkebulan:action:save' => 'Save',
    'alkebulan:action:cancel' => 'Cancel',
    'alkebulan:action:delete' => 'Delete',
    'alkebulan:action:export' => 'Export',
    'alkebulan:action:import' => 'Import',
    'alkebulan:action:search' => 'Search',
    'alkebulan:action:filter' => 'Filter',
    'alkebulan:action:sort' => 'Sort',
    'alkebulan:action:next' => 'Next',
    'alkebulan:action:previous' => 'Previous',
    'alkebulan:action:close' => 'Close',
    
    // Messages
    'alkebulan:message:success' => 'Operation completed successfully',
    'alkebulan:message:error' => 'An error occurred',
    'alkebulan:message:warning' => 'Warning',
    'alkebulan:message:info' => 'Information',
    'alkebulan:message:saved' => 'Changes saved successfully',
    'alkebulan:message:deleted' => 'Item deleted successfully',
    'alkebulan:message:no_data' => 'No data available',
    'alkebulan:message:loading' => 'Loading...',
    'alkebulan:message:confirm_delete' => 'Are you sure you want to delete this?',
    
    // Errors
    'alkebulan:error:invalid_input' => 'Invalid input provided',
    'alkebulan:error:required_field' => 'This field is required',
    'alkebulan:error:network' => 'Network error occurred',
    'alkebulan:error:server' => 'Server error occurred',
    'alkebulan:error:not_found' => 'Item not found',
    'alkebulan:error:permission' => 'Permission denied',
    'alkebulan:error:limit' => 'Request limit exceeded',
    
    // Admin
    'alkebulan:admin:settings' => 'Alkebulan AI Settings',
    'alkebulan:admin:config' => 'Configuration',
    'alkebulan:admin:status' => 'Component Status',
    'alkebulan:admin:enable' => 'Enable Component',
    'alkebulan:admin:disable' => 'Disable Component',
    'alkebulan:admin:api_key' => 'API Configuration',
    'alkebulan:admin:api_key_desc' => 'Configure your API key for Alkebulan AI',
    'alkebulan:admin:max_requests' => 'Max Requests Per Day',
    'alkebulan:admin:max_requests_desc' => 'Maximum number of API requests allowed per day',
    'alkebulan:admin:cache_enabled' => 'Enable Caching',
    'alkebulan:admin:cache_enabled_desc' => 'Cache analysis results for faster retrieval',
    'alkebulan:admin:analytics_enabled' => 'Enable Analytics',
    'alkebulan:admin:analytics_enabled_desc' => 'Track AI feature usage and generate reports',
    
    // About
    'alkebulan:about:name' => 'Alkebulan AI',
    'alkebulan:about:version' => 'Version 1.0',
    'alkebulan:about:release' => 'Stable Release',
    'alkebulan:about:framework' => 'OSSN 7.6+',
    'alkebulan:about:description' => 'Advanced AI-powered analytics and insights component for OSSN',
    'alkebulan:about:features' => 'Features',
    'alkebulan:about:requirements' => 'Requirements',
    'alkebulan:about:documentation' => 'Documentation',
    
    // Image Generator - V2.0 NEW
    'alkebulan:image' => 'Image Generator',
    'alkebulan:image:desc' => 'Generate stunning images from text prompts',
    'alkebulan:image:generator' => 'Image Generator',
    'alkebulan:image:prompt' => 'Describe Your Image',
    'alkebulan:image:prompt:placeholder' => 'e.g., A serene mountain landscape with snow-capped peaks...',
    'alkebulan:image:style' => 'Visual Style',
    'alkebulan:image:style:colorful' => '🌈 Colorful',
    'alkebulan:image:style:abstract' => '✨ Abstract',
    'alkebulan:image:style:minimalist' => '■ Minimalist',
    'alkebulan:image:style:dark' => '🌙 Dark',
    'alkebulan:image:style:gradient' => '🎯 Gradient',
    'alkebulan:image:style:geometric' => '◼ Geometric',
    'alkebulan:image:width' => 'Width',
    'alkebulan:image:height' => 'Height',
    'alkebulan:image:format' => 'Image Format',
    'alkebulan:image:public' => 'Make image public',
    'alkebulan:image:generate' => 'Generate Image',
    'alkebulan:image:generating' => 'Generating...',
    'alkebulan:image:clear' => 'Clear',
    'alkebulan:image:download' => '⬇ Download',
    'alkebulan:image:share' => '↗ Share',
    'alkebulan:image:preview' => 'Preview',
    'alkebulan:image:gallery' => 'Your Gallery',
    'alkebulan:image:statistics' => 'Your Statistics',
    'alkebulan:image:total' => 'Images Generated',
    'alkebulan:image:styles' => 'Styles Used',
    'alkebulan:image:avgtime' => 'Avg Generation',
    'alkebulan:image:generated' => 'Image generated successfully!',
    'alkebulan:image:failed' => 'Failed to generate image',
    'alkebulan:image:deleted' => 'Image deleted',
    'alkebulan:image:error:prompt' => 'Prompt cannot be empty',
    'alkebulan:image:error:length' => 'Prompt too long (max 500 characters)',
    
    // Menu Items
    'alkebulan:menu:dashboard' => 'Dashboard',
    'alkebulan:menu:features' => 'Features',
    'alkebulan:menu:chat' => 'Chat',
    'alkebulan:menu:analytics' => 'Analytics',
    'alkebulan:menu:image' => 'Image Generator',
    'alkebulan:menu:settings' => 'Settings',
);
