/**
 * Homelancer Program/Software
 *
 * @package      Homelancer Package for Ossn
 * @author       Geocadin RA <ossn@homelancer.com>
 * @author_url   http://www.homelancer.com/
 * @copyright    2017 Homelancer.com
 * @license      General Public Licence http://www.opensource-socialnetwork.org/licence
 * @link         http://www.opensource-socialnetwork.org/licence
*/

Ossn.RegisterStartupFunction(function() {
	$(document).ready(function() {
		/* 
		* Create definitions for containers and selectors in which we 
		* will replace the pagination with scrolling.
		*/
		
		var params=[];
    
		/* Newsfeed */
		params.push({
			items_Container:'.user-activity',
			item_Entity:'.ossn-wall-item',
		});

		/* Homelancer Custom Fields */
		params.push({
			items_Container:'#hcf-fields-list',
			item_Entity:'tr.field-item',
		});

		/* Administrator Users List/Unvalidated Users List */
		params.push({
			items_Container:'table.ossn-users-list',
			item_Entity:'tr',
		});
    
		/* Forum */
		params.push({
			items_Container:'.discussion-items',
			item_Entity:'.item.row',
		});

		/* Latest Components */
		params.push({
			items_Container:'.latest-components',
			item_Entity:'li',
		});
    
		/* Search Results - Users */
		params.push({
			items_Container:'.ossn-search-page .search-data',
			item_Entity:'.ossn-users-list-item',
		});

		/* Search Results - Groups */
		params.push({
			items_Container:'.ossn-search-page .search-data',
			item_Entity:'.group-search-items',
		});

		/* Search Results - Forum */
		params.push({
			items_Container:'.ossn-search-page .search-data',
			item_Entity:'.search-topics',
		});
    
		/* Define the scroller class/object */
		HomeScroller = {
			items_Container:     '.user-activity',
			item_Entity:         '.ossn-wall-item',
			pagination_Container:'.container-table',
			pagination_Selector: '.pagination.ossn-pagination',
			current_Selector:    'li.active',
			newsfeed:            {selector:'.newsfeed-right', container:null, active:false, lock:false, width:0, height:0, bottom: 0},
			loadingHtml:         '<div class="hs-loading">Loading... <img src="/components/HomeScroller/spinner.gif" /></div>',
			back2TopHtml:        '<div class="hs-back2top"><i class="fa fa-angle-double-up"></i></div>',
			show:                function(elems) { elems.show(); },
			nextPageUrl:         null,
			scrolltimeout:		 null,
			throttle:            110,

			init: function(options) {
				/* Check if there are other arguments aside from default */
				for (var key in options) {
					/* Set the argument to our object */
					HomeScroller[key] = options[key];
				}
				
				/* check the current page for presence of the required elements */
				if (($('body').find(HomeScroller.pagination_Selector).length) &&
					($('body').find(HomeScroller.items_Container).length && $('body').find(HomeScroller.item_Entity).length) 
				){
					HomeScroller.newsfeed.container = $(HomeScroller.newsfeed.selector);
					if (HomeScroller.newsfeed.container.length){
						HomeScroller.newsfeed.active = true;
						HomeScroller.newsfeed.width = HomeScroller.newsfeed.container.outerWidth();
						HomeScroller.newsfeed.height = HomeScroller.newsfeed.container.outerHeight();
					}
				
					/* Bind the scrolling event to our function */
					$(function(){
						$('body').css('height','auto');  
						HomeScroller.back2top('init');
						HomeScroller.getNextPageUrl($('body'));
						$(window).bind('scroll', HomeScroller.scroll);
						HomeScroller.scroll();
					});
				}
			},

			scroll: function() {
				if (!HomeScroller.scrollTimeout) {
					HomeScroller.scrollTimeout = setTimeout(function () {
						/* Load the next page if we reached the last item of the current page elements. */
						if (HomeScroller.nearBottom() && HomeScroller.shouldLoadNextPage()) {
							HomeScroller.loadNextPage();
						}
						HomeScroller.scrollTimeout = null;
					}, HomeScroller.throttle);
				}			
			},

			nearBottom: function() {
				/* Get the offset of our cursor in relation to the last element of the paged items */
				var scrollTop = $(window).scrollTop(),
					windowHeight = $(window).height(),
					lastItemOffset = $(HomeScroller.items_Container).find(HomeScroller.item_Entity).last().offset();
				var scrollBottom = (scrollTop+windowHeight);
				if (scrollTop > (windowHeight/2)){
					HomeScroller.back2top('show'); 
				} else {
					HomeScroller.back2top('hide'); 
				}
				if (HomeScroller.newsfeed.active){
					if (scrollBottom > HomeScroller.newsfeed.height){
						var footer=$('footer').offset();
						if (scrollBottom > footer.top){
							HomeScroller.newsfeed.bottom = scrollBottom - footer.top;
						} else {
							HomeScroller.newsfeed.bottom = 0;
						}
						HomeScroller.newsfeedScroll('lock'); 
					} else {
						HomeScroller.newsfeedScroll('release'); 
					}
					
				}
				
				
				if (!lastItemOffset) return;
				return (scrollBottom > lastItemOffset.top );
			},

			shouldLoadNextPage: function() {
				/* check if there are succeeding pages still to load */
				return !!HomeScroller.nextPageUrl; 
			},
    
			loadNextPage: function() {
				/* load the next page after the current page by loading the DOM object of the next page URL */
				var nextPageUrl = HomeScroller.nextPageUrl,
					loading = $(HomeScroller.loadingHtml);
				
				HomeScroller.nextPageUrl = null;
				/* Let's inform the user that we are currently working */
				loading.appendTo(HomeScroller.items_Container);
				/* Get the DOM specified by the next page URL */
				$.get(nextPageUrl, function(html) {
					/* html now contains the DOM object */
					var dom = $(html);
					var items = dom.find(HomeScroller.items_Container).find(HomeScroller.item_Entity); 
					if (items.find('.ossn-comment-attach-photo').length) {
						HomeScroller.emojiis(items);
					}
					loading.remove();
					/* we now have the content of the succeeding page stored in 'items'. Let's add it to the container */
					HomeScroller.show(items.hide().appendTo(HomeScroller.items_Container));
					
					/* On to the next page. */
					HomeScroller.getNextPageUrl(dom);
					HomeScroller.scroll();
				});
			},
			
			getNextPageUrl: function(container) {
				/* Check if there are succeeding pages after the current one */
				var pagination = $(container).find(HomeScroller.pagination_Container);
				var currentPageUrl = pagination.find(HomeScroller.pagination_Selector).find(HomeScroller.current_Selector).find('a').attr('href');
				HomeScroller.nextPageUrl = pagination.find(HomeScroller.pagination_Selector).find(HomeScroller.current_Selector).next().find('a').attr('href');
				/* If the next page is still the current page, it means we have reached the last page. */
				if (currentPageUrl==HomeScroller.nextPageUrl){
					/* No more page to load. Blank out the next page URL. */
					HomeScroller.nextPageUrl=null;
				}
				/* Remove the pagination buttons */
				pagination.remove();
			} ,
			
			back2top: function(action){
				var backtoTop = $('body').find('.hs-back2top');
				if (action=='init'){
					backtoTop = $(HomeScroller.back2TopHtml),
					backtoTop.insertBefore($('footer'));
				
					/* Unbind/Bind the mouse click to our function */
					$(function(){
						$('.hs-back2top').off('click');
						$('.hs-back2top').on('click', function(){
							$('html, body').animate({
								scrollTop: $("body").offset().top
							}, 300);
						});
					});
				}
				if ( ($('div.ossn-page-loading-annimation').css('display')) == 'none'){
					if ( ((action=='show') || (action=='hide')) && (backtoTop.hasClass('hs-back2top')) ){
						if (action=='show'){
							backtoTop.css('bottom','5px');
						} else {
							backtoTop.css('bottom','-100px');
						}
					}
				}
			},
			
			newsfeedScroll: function(action){
				if (action=='lock'){
					if (!HomeScroller.newsfeed.lock){
						HomeScroller.newsfeed.lock = true;
						$(HomeScroller.newsfeed.container).css({
							position:'fixed',
							width:HomeScroller.newsfeed.width+'px',
							bottom:HomeScroller.newsfeed.bottom+'px'
						});
					} else {
						$(HomeScroller.newsfeed.container).css({
							bottom:HomeScroller.newsfeed.bottom+'px'
						});
					}
				} else if (action=='release' && HomeScroller.newsfeed.lock){
					HomeScroller.newsfeed.lock = false;
					$(HomeScroller.newsfeed.container).css({position:'relative',bottom:'auto'});
				}
			},

			
			emojiis: function(items){
				var emojii = {
					icon:$(HomeScroller.items_Container).find('.ossn-comment-attach-photo i.fa-smile-o').parent().first(),
					dropdown:$(HomeScroller.items_Container).find('.dropdown.emojii-container-main').first()
				};
				if (!items.find('.ossn-comment-attach-photo i.fa-smile-o').length){
					$(emojii.icon).clone().insertAfter(items.find('.ossn-comment-attach-photo'));
					$(emojii.dropdown).clone().appendTo(items.find('.comment-container'));
				}
			},

		}
    
		var len = params.length;
		for (var i = 0; i < len; i++) {
			var args=params[i];
			if (($('body').find(args.items_Container).length) && ($('body').find(args.item_Entity).length)){
				HomeScroller.init(args);
				break;
			}
		}
	});
});




