/**
 * Homelancer Program/Software
 *
 * @package      Homelancer Package for Ossn
 * @author       Geocadin RA <ossn@homelancer.com>
 * @author_url   http://www.homelancer.com/
 * @copyright    2017 Homelancer.com
 * @license      General Public Licence http://www.opensource-socialnetwork.org/licence
 * @link         http://www.opensource-socialnetwork.org/licence
*/

Ossn.RegisterStartupFunction(function() {
	$(document).ready(function() {
		/* Find the topbar menu */
		var topMenu = $('.topbar-menu-right');
		if (topMenu.length){
			/* check if we already defined our home link */
			if (topMenu.find('#home').attr('id')=='home'){
				return;
			}
			/* Add the Home link to our site */
			topMenu.prepend('<li id="home"><a href="'+Ossn.site_url+'"><div class="ossn-icon ossn-icons-topbar-home"><i class="fa fa-home"></i></div></a></li>');
			/*Fix the color to be the same with the Friends icon */
			topMenu.find('.ossn-icons-topbar-home i').css('color', topMenu.find('.ossn-icons-topbar-friends i').css('color'));

			$('#sidebar-toggle').on('click', function(){
				var scrollTimeout = null;
				scrollTimeout = setTimeout(function () {
					topbarLeft();
					scrollTimeout = null;
				}, 600);
			});
			$(window).on('resize', function(){
				topbarLeft();
			});
			topbarLeft();
		}
		
		function topbarLeft(){
			var containerLeft = $('.ossn-inner-page .container').offset().left,
				containerWidth = $('.ossn-inner-page .container').outerWidth(),
				containerMax = '100%',
				winWidth = $(window).width();
				
			if ($('#sidebar-toggle').attr('data-toggle')=='1') {
				var sidebarWidth = $('.sidebar').outerWidth();
				containerLeft = (containerLeft - sidebarWidth);
				if (winWidth<=(sidebarWidth+containerWidth)){
					containerMax = (winWidth - sidebarWidth)+'px';
				} else {
					containerLeft = 'auto';
					containerMax = '100%';
				}
			} else {
				containerLeft = 'auto';
			}
			$('.topbar .container').css({'margin-left':containerLeft, 'max-width':containerMax});
		}
		
	});
});




