<?php
/**
 * Open Source Social Network
 *
 * @package   (softlab24.com).ossn
 * @author    OSSN Core Team <info@softlab24.com>
 * @copyright (C) SOFTLAB24 LIMITED
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */

define('__SIGNUP_FIELDS__', ossn_route()->com . 'signupfields/');
/**
 * Initialize the component
 *
 * @return void
 */
function com_signup_fields_mobile_init(){
		ossn_add_hook('user', 'signup:fields', 'com_signup_fields');
		ossn_add_hook('user', 'default:fields', 'com_signup_fields_mobile');

		$component = new OssnComponents();
		$settings  = $component->getComSettings('signupfields');
		if($component->isActive('CustomFields') && $settings && $settings->display_on_cf_about == 'yes') {
			ossn_add_hook('profile', 'subpage', 'com_signup_fields_mobile_customfield_about_user_page');
		}
		
		if(ossn_isAdminLoggedin()) {
			ossn_register_action('signupfields/admin/settings', __SIGNUP_FIELDS__ . 'actions/signupfields/admin/settings.php');
			ossn_register_com_panel('signupfields', 'settings');
		}
}

function com_signup_fields_mobile_customfield_about_user_page($hook, $type, $return, $params) {
		if (isset($params['subpage']) && $params['subpage'] == 'about') {
			echo ossn_plugin_view('signupfields/CustomField', $params);
		}
}

/**
 * Signup fields
 *
 * @params string $hook Name of hook is user
 * @params string $type Type of hook is signup fields
 * @params array  $fields A list of signup fields
 *
 * @return array
 */
function com_signup_fields_mobile($hook, $type, $fields){
		$component = new OssnComponents();
		if($component->isActive('CustomFields')) {
			$label = true;
			$placeholder = ossn_print('com:signupfields:mobile:label');
		} else {
			$label = ossn_print('com:signupfields:mobile:label');
			$placeholder = '';
		}
		$extrafield = 	array(
			'name' => 'com:signupfields:mobile',
			'label' => $label,
			'placeholder' => $placeholder,
			'display_on_about_page' => true
		);
		$fields['required']['text'][] = $extrafield;
		return $fields;
}
ossn_register_callback('ossn', 'init', 'com_signup_fields_mobile_init');
