//<script>
$setRTL = function(elm, $type) {
    $isRTL = function(str) {
        return /^[\u0600-\u06FF]/.test(str);
    };
    if ($type == 'keypress') {
        $('body').on('keypress', elm, function() {
            $text = $(this).val();
            if ($isRTL($text)) {
                $(this).addClass('rltsupport');
            } else {
                $(this).removeClass('rltsupport');
            }
        });
    } else {
        var $elms = $(elm + ":not(.rltsupport)");
        if ($elms) {
            $.each($elms, function() {
                $text = $(this).text();
                if ($isRTL($text)) {
                    $(this).addClass('rltsupport');
                }
            });
        }
    }
};
$rtlInit = function() {
    $setRTL('select', 'keypress');
    $setRTL('textarea', 'keypress');
    $setRTL('input', 'keypress');
    $setRTL('.post-contents p');
    $setRTL('.comment-text');
    $('body').on('keypress', "[contenteditable='true']", function() {
        $text = $(this).text();
        if ($isRTL($text)) {
            $(this).addClass('rltsupport');
        } else {
            $(this).removeClass('rltsupport');
        }
    });
};
$(document).ready(function() {
    $rtlInit();
});
$(document).ajaxComplete(function() {
    setTimeout(function() {
        $rtlInit();
    }, 500);
});