<?php
/**
 * Open Source Social Network
 *
 * @package   (softlab24.com).ossn
 * @author    OSSN Core Team <info@softlab24.com>
 * @copyright (C) SOFTLAB24 LIMITED
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      https://www.opensource-socialnetwork.org/
 */
 
$site  = new OssnFile;
$site->setFile('logo_site');
$site->setExtension(array(
		'png',
));

if(isset($site->file['tmp_name']) && $site->typeAllowed()){
	$file = $site->file['tmp_name'];
	$size = filesize($file);
	if($size > 0){
			if($size > 500000){ //500KB
					ossn_trigger_message(ossn_print('theme:tayonapink:logo:large'), 'error');
					redirect(REF);
			}
			$contents = file_get_contents($file);
			if(strlen($contents) > 0 && file_put_contents(ossn_route()->themes.'TayonaPink/images/logo.png', $contents)){
					$cache  = ossn_site_settings('cache');
					if($cache == false) {
							$done = true;
					} else {
							$done = 2;
					}								
			} else {
				$done = false;
		
			}
	}
} elseif(!isset($site->file['tmp_name'])) {
	// GREETING PART
	$greetingText = input('tys:greeting_text');
	if(!strlen($greetingText)) {
		$greetingText = false;
	}
	
	// LOGO PART
	// use empty png file
	$im = imagecreatefrompng(ossn_route()->themes.'TayonaPink/images/transparent-logo.png');
	// create alpha channel, otherwise the background will be black
	imagesavealpha($im, true);
	
	$logoText = input('tys:logo_text_text');
	if(!strlen($logoText)) {
		$logoText = ' ';
	}

	$logoColor = input('tys:logo_text_color');
	preg_match_all("/\((.*?)\)/", $logoColor, $colors);
	$rgb =  explode (",", $colors[1][0]);
	$txtColor = imagecolorallocate($im, $rgb[0], $rgb[1], $rgb[2]);

	$logoSize = input('tys:logo_text_size');
	if($logoSize == '' || $logoSize < 1) {
		$logoSize = 1;
	}
	$angle    = 0;
	$fontPath = ossn_route()->themes.'TayonaPink/fonts/PT_Sans/PTSans-Bold.ttf';

	// calculate bounding box depending on vars above
	$bbox = imagettfbbox ($logoSize, $angle, $fontPath, $logoText);
	$x    = $bbox[0] + (imagesx($im) / 2) - ($bbox[4] / 2);
	$y    = $bbox[1] + (imagesy($im) / 2) - ($bbox[5] / 2) - ($logoSize/2.5);
	
	// put logoText into image - we need ttftext because of utf-8 support
	imagettftext($im, $logoSize, $angle, $x , $y, $txtColor, $fontPath, $logoText );
	// create new png in memory
	ob_start();
	imagepng($im);
	// retrieve it from mememory and save to file
	if(file_put_contents(ossn_route()->themes.'TayonaPink/images/logo.png', ob_get_clean())){
			// save other settings
			$setting = new OssnSite;
			if(!$greetingText) {
				$setting->deleteSetting('tys:greeting_text');
			} else {
				$setting->setSetting('tys:greeting_text', $greetingText);
			}
			$setting->setSetting('tys:logo_text_text', $logoText);
			$setting->setSetting('tys:logo_text_color', $logoColor);
			$setting->setSetting('tys:logo_text_size', $logoSize);
			
			$cache  = ossn_site_settings('cache');
			if($cache == false) {
					$done = true;
			} else {
					$done = 2;
			}								
	} else {
		$done = false;
		
	}
	imagedestroy($im);
}


$admin  = new OssnFile;
$admin->setFile('logo_admin');
$admin->setExtension(array(
		'jpg',
		'jpeg',
));
if(isset($admin->file['tmp_name']) && $admin->typeAllowed()){
	$file = $admin->file['tmp_name'];
	$size = filesize($file);
	if($size > 0){
			if($size > 500000){ //500KB
					ossn_trigger_message(ossn_print('theme:tayonapink:logo:large'), 'error');
					redirect(REF);
			}
			$contents = file_get_contents($file);
			if(strlen($contents) > 0 && file_put_contents(ossn_route()->themes.'TayonaPink/images/logo_admin.jpg', $contents)){
					$cache  = ossn_site_settings('cache');
					if($cache == false) {
							$done = true;
					} else {
							$done = 2;
					}								
			} else {
				$done = false;
		
			}
	}
}

$setting = new OssnSite;
if(input('tys:extra_newsfeed_link')) {
	$setting->setSetting('tys:extra_newsfeed_link', 'checked');
} else {
	$setting->deleteSetting('tys:extra_newsfeed_link');
}

if($done === true){
	ossn_trigger_message(ossn_print('theme:tayonapink:logo:changed'));
	redirect(REF);	
} elseif($done == 2){
	//redirect and flush cache
	ossn_trigger_message(ossn_print('theme:tayonapink:logo:changed'));	
	$action = ossn_add_tokens_to_url("action/admin/cache/flush");
	redirect($action);	
} else {
	ossn_trigger_message(ossn_print('theme:tayonapink:logo:failed'), 'error');
	redirect(REF);		
}
