<?php
/**
 * Open Source Social Network
 * @link      https://www.opensource-socialnetwork.org/
 * @package   Privacy Changer
 * @author    Michael Zülsdorff <ossn@z-mans.net>
 * @author    OSSN Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 */

define('__PRIVACY_CHANGER__', ossn_route()->com . 'PrivacyChanger/');

function com_privacy_changer_init()
{
	if (ossn_isLoggedin()) {
		ossn_add_hook('wall', 'post:menu', 'com_privacy_changer_wall_post_menu');
		ossn_register_action('wall/post/privacy', __PRIVACY_CHANGER__ . 'actions/wall/post/privacy.php');
	}
}

function com_privacy_changer_wall_post_menu($hook, $type, $return, $params) {
		$user = ossn_loggedin_user();
		if($params['post']->type == 'group') {
				$group = ossn_get_group_by_guid($params['post']->owner_guid);
		}
		if(
				$params['post']->poster_guid == ossn_loggedin_user()->guid ||
				$params['post']->owner_guid == $user->guid ||
				(isset($group) && ($group->owner_guid == $user->guid || $group->isModerator($user->guid))) ||
				$user->canModerate()
		) {
				$privacyurl = ossn_site_url("action/wall/post/privacy?post={$params['post']->guid}", true);

				ossn_unregister_menu('privacy', 'wallpost');
				ossn_register_menu_item('wallpost', array(
						'name'      => 'privacy',
						'class'     => 'ossn-wall-post-privacy',
						'text'      => ossn_print('privacy'),
						'href'      => $privacyurl,
						'data-guid' => $params['post']->guid,
				));
		} else {
				ossn_unregister_menu('privacy', 'wallpost');
		}
		return ossn_view_menu('wallpost', 'wall/menus/post-controls');
}

ossn_register_callback('ossn', 'init', 'com_privacy_changer_init');