<?php
/**
 * Open Source Social Network
 * @link      https://www.opensource-socialnetwork.org/
 * @package   Privacy Changer
 * @author    Michael Zülsdorff <ossn@z-mans.net>
 * @author    OSSN Core Team <info@openteknik.com>
 * @copyright (C) OpenTeknik LLC
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 */
$ossnwall = new OssnWall;
$id = input('post');
$post = $ossnwall->GetPost($id);

if (($post->type != 'user') || ($post->type == 'user' && !ossn_loggedin_user()->canModerate())) {
    if (($post->type != 'user') || ($post->type == 'user' && $post->poster_guid != ossn_loggedin_user()->guid && $post->owner_guid !== ossn_loggedin_user()->guid)) {
        if (!ossn_is_xhr()) {
            ossn_trigger_message(ossn_print('com:privacy:changer:access:denied'), 'error');
            redirect(REF);
        } else {
            echo 0;
            exit;
        }
    }
}

$post->data = new stdClass;
$post->data->access = $post->access; // just in case we have to deal with OSSN_PRIVATE some day ...
if ($post->access == OSSN_PUBLIC) {
	$post->data->access = OSSN_FRIENDS;
	$msg = 'com:privacy:changer:changed:to:friends';
} else {
	if ($post->access == OSSN_FRIENDS) {
		$post->data->access = OSSN_PUBLIC;
		$msg = 'com:privacy:changer:changed:to:public';
	}
}
$names = array(
	'type',
	'subtype',
);
$values = array(
	$post->type,
	$post->subtype,
);

if ($post->updateObject($names, $values, $post->guid)) {
    if (ossn_is_xhr()) {
        echo 1;
		exit;
    } else {
        ossn_trigger_message(ossn_print($msg), 'success');
        redirect(REF);
    }
} else {
    if (ossn_is_xhr()) {
        echo 0;
		exit;
    } else {
        ossn_trigger_message(ossn_print('com:privacy:changer:change:failed'), 'error');
        redirect(REF);
    }
}
