<?php
/**
 * Open Source Social Network
 *
 * @package   Open Source Social Network
 * @author    Informatikon Core Team <info@softlab24.com>
 * @copyright (C) SOFTLAB24 LIMITED
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      http://www.informatikon.com/
 */
error_reporting(E_ALL);
ini_set("display_errors", 1);

define('SYSTEM_INFO_VERSION', '2.6');
// temporary file used for checksum computing
define('TMP_CHECKSUM_FILE', 'checksum.tmp');
// file containing single checksum to be found in root of component or theme directory
define('SINGLE_CHECKSUM_FILE', 'ossn_chk.md5');
// repository url of bundled release checksums
define('CHECKSUM_REPOSITORY_URL', 'https://z-mans.net/ossn-checksums/');
// default no of Ossn tables
define('MINIMUM_NUMBER_OF_TABLES', 11);
// minimum no of Ossn admin users
define('MINIMUM_NUMBER_OF_ADMINS', 1);
// minimum supported Ossn release (3.01)
define('MINIMUM_SUPPORTED_RELEASE', 1439295894);

	header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache");

	echo"
	<!DOCTYPE html>
	<html lang='en'>
	<head>
	<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
	<meta http-equiv='Cache-Control' content='no-cache, no-store, must-revalidate' />
	<meta http-equiv='Pragma' content='no-cache' />
	<meta http-equiv='Expires' content='0' />
	<style>
	table {
    border-collapse: collapse;
	}
	td, th {
    border: 1px solid #000000;
    font-size: 100%;
    vertical-align: baseline;
	padding: 5px;
	}
	body, td, th, h1, h2 {
    font-family: sans-serif;
	margin: revert !important;
	}
	pre {
		font-size: 16px;
		color: red;
	}
	table pre {
		color: black;
	}
	iframe {
		height: 0px;
		width: 0px;
		border-width: 0px;
	}
	.attention {
		color: red;
	}
	.warning {
		color: #007aff;
	}
	.confirmed {
		color: black;
	}
	.success {
		color: green;
	}
	.ossn-exception-handler {
		display: none;
	}
	</style>
	</head>";
	echo '<body>';
	echo '<h2>Ossn System Info ' . SYSTEM_INFO_VERSION . '</h2>';
	echo '<br />';
	
	$location = dirname(__FILE__) . '/';

	// First asure that ossninfo.php has been installed in the right location
	if(!file_exists('opensource-socialnetwork.xml')) {
		exit('<pre><b>Error: No Ossn installation found in <i>' . $location . '</i> - verify location</b></pre>');
	}
	
	// Asure we're running at least Ossn ossn-v3.01-1439295894
	// as former versions don't have cache settings, etc
	$version_file = file_get_contents('opensource-socialnetwork.xml');
	$version_file = (array)simplexml_load_string($version_file);
	if((int) $version_file['release'] < MINIMUM_SUPPORTED_RELEASE) {
		exit('<pre><b>Error: Ossn releases prior to 3.01 are not supported - you should think of updating your outdated installation</b></pre>');
	}

	// check for password protection
	$protected = false;
	if(file_exists('error_log')) {
		$fn = fopen('error_log', 'r');
		$firstline = fgets($fn);
		fclose($fn);
		$pos = strpos($firstline, 'system-info-password');
		if($pos !== false) {
			$protect_password_array = explode(" ", $firstline);
			$protect_password = $protect_password_array[1];
			$protected = true;
		}
	}

	$key = '';
	$protect_password_checked = false;

	foreach($_GET as $key => $value) {
		if($protected && !$protect_password_checked) {
			if($key !== 'password') {
				exit('<pre><b>Error: Password required - access denied</b></pre>');
			}
			if($value !== substr($protect_password, 0, strlen($protect_password) - 1)) {
				exit('<pre><b>Error: Wrong password - access denied</b></pre>');
			}
			$protect_password_checked = true;
		}
		// handle several special options that would exit, first
		if($key === 'view' && $value === 'files') {
			$files = array('opensource-socialnetwork.xml', '.htaccess', 'php.ini', '.php.ini', '.user.ini', 'error_log');
			foreach($files as $file) {
				echo '--------------------------------------------------------------------------------------<br />';
				echo $file . ':<br />';
				echo '--------------------------------------------------------------------------------------<br />';
				$file = $location . $file;
				if(file_exists($file)) {
					echo '<pre style=color:black>' . htmlentities(file_get_contents($file)) . '</pre>';
				} else {
					echo '<pre>no such file</pre>';
				}
				echo '<br />';
			}
			exit;
		}
		if($key === 'view' && $value === 'phpinfo') {
			phpinfo();
			exit;
		}
		if($key === 'view' && $value === 'meminfo') {
			echo '<h3>Server Environment</h3>';
			echo '<table>';
			echo '<tr><td>Operating System</td><td>' . php_uname() . '</td></tr>';
			echo '<tr><td>Memory Info</td><td>' . tool_system_info_dump(tool_system_info_getSystemMemInfo()) . '</td></tr>';
			echo '</table>';
			exit;
		}
		if($key === 'view' && $value === 'dirtree') {
			echo '<h3>Ossn Directory Listing</h3>';
			$temp_file = tmpfile();
			$temp_path = stream_get_meta_data($temp_file)['uri'];
			$temp_owner = fileowner($temp_path);
			if (function_exists('posix_getpwuid')) {
				$temp_owner = posix_getpwuid($temp_owner)['name'];
				echo "The owner of your webserver process is: <b>" . $temp_owner . "</b><br /><br />";
			} else {
				echo "The owner-id of your webserver process is: <b>" . $temp_owner . "<b><br /><br />";
			}	
			fclose($temp_file);
			
			$depth = false;
			$recurse = true;
			if (array_key_exists('depth', $_GET) && (int)$_GET['depth'] > 0) {
				$depth = (int)$_GET['depth'];
				if($depth == 1) {
					$recurse = false;
				}
			}

			$dirlist = tool_system_info_getFileList("./", $recurse, $depth);
			array_multisort(array_column($dirlist, 'name'), SORT_ASC, $dirlist);
			$wrong_permission_warning = '';
			$wrong_owner_warning = '';
			echo "<table border=\"1\">\n";
			echo "<thead>\n";
			echo "<tr><th>Name</th><th>Perms</th><th>Owner</th><th>Size</th><th>Last Modified</th></tr>\n";
			echo "</thead>\n";
			echo "<tbody>\n";
			foreach($dirlist as $file) {
				echo "<tr>\n";
				echo "<td>{$file['name']}</td>\n";
				if($file['perms'] !== '0755' && $file['perms'] !== '0644') {
					echo "<td class='attention'><b>{$file['perms']}</b></td>\n";
					$wrong_permission_warning = '<pre><b>Attention: Wrong permission(s) detected</b></pre>';
				} else {
					echo "<td>{$file['perms']}</td>\n";
				}
				if($file['owner'] !== $temp_owner) {
					echo "<td class='attention'><b>{$file['owner']}</b></td>\n";
					$wrong_owner_warning = '<pre><b>Attention: Wrong owner(s) detected</b></pre>';
				} else {
					echo "<td>{$file['owner']}</td>\n";
				}
				echo "<td>{$file['size']}</td>\n";
				echo "<td>",date('d M Y', $file['lastmod']),"</td>\n";
				echo "</tr>\n";
			}
			echo "</tbody>\n";
			echo "</table>\n\n";
			echo $wrong_permission_warning;
			echo $wrong_owner_warning;
			exit;
		}
		if($key === 'rename') {
			if($protect_password_checked) {
				if(strlen($value) == 0) {
					exit('<pre><b>Error: Filename required</b></pre>');
				}
				if(strpos($value, '..') !== false) {
					exit('<pre><b>Error: Traversing back is not permitted</b></pre>');
				}
				if(strpos($value, '*') !== false || strpos($value, '?') !== false) {
					exit('<pre><b>Error: Wildcards are not permitted</b></pre>');
				}
				if(! @rename('./' . $value, './' . $value . '.BAK')) {
					exit('<pre><b>Error: Renaming not possible - check filename and permissions</b></pre>');
				}
				echo "<pre class='success'><b>" . $value . ' has been renamed to ' . $value . ".BAK</b></pre>";
				exit;
			} else {
				exit('<pre><b>Error: Password required - access denied</b></pre>');
			}
		}
		if($key === 'renamebak') {
			if($protect_password_checked) {
				if(strlen($value) == 0) {
					exit('<pre><b>Error: Filename required</b></pre>');
				}
				if(strpos($value, '..') !== false) {
					exit('<pre><b>Error: Traversing back is not permitted</b></pre>');
				}
				if(strpos($value, '*') !== false || strpos($value, '?') !== false) {
					exit('<pre><b>Error: Wildcards are not permitted</b></pre>');
				}
				if(! @rename('./' . $value . '.BAK', './' . $value)) {
					exit('<pre><b>Error: Restoring not possible - check filename and permissions</b></pre>');
				}
				echo "<pre class='success'><b>" . $value . '.BAK has been restored to ' . $value . "</b></pre>";
				exit;
			} else {
				exit('<pre><b>Error: Password required - access denied</b></pre>');
			}
		}
	}

	if($protected && !$protect_password_checked) {
		exit('<pre><b>Error: Password required - access denied</b></pre>');
	}
	
	// default output starts here

	// 1. Server section
	// =================================================
	echo '<h3>Server Environment</h3>';
	echo '<table>';
	echo '<tr><td>Operating System</td><td>' . php_uname() . '</td></tr>';
	echo '<tr><td>Host Name</td><td>' . $_SERVER['SERVER_NAME'] . '</td></tr>';
	$dns_ip = $_SERVER['SERVER_ADDR'];
	echo '<tr><td>Host IP</td><td>' . $dns_ip . '</td></tr>';
	$reverse_domain = gethostbyaddr($dns_ip);
	echo '<tr><td>Host Name (reverse lookup)</td><td>' . $reverse_domain . '</td></tr>';
	$open_ports = tool_system_info_openPortScan($_SERVER['SERVER_NAME']);
	echo '<tr><td>Open Ports (1 - 1024)</td><td>' . $open_ports . '</td></tr>';
	echo '<tr><td>Execution path</td><td>' . $location . '</td></tr>';
	echo '</table>';


	// 2. PHP section
	// =================================================
	echo '<h3>PHP Environment</h3>';
	echo '<table>';
	echo '<tr><td>Version</td><td>' . PHP_VERSION . '</td></tr>';
	echo '<tr><td>Server APi</td><td>' . PHP_SAPI . '</td></tr>';
	echo '<tr><td>&nbsp;</td><td></td></tr>';
	echo '<tr><td>memory_limit</td><td>' . ini_get('memory_limit') . '</td></tr>';
	echo '<tr><td>register_globals</td><td>' . ini_get('register_globals') . '</td></tr>';
	echo '<tr><td>post_max_size</td><td>' . ini_get('post_max_size') . '</td></tr>';
	echo '<tr><td>upload_max_filesize</td><td>' . ini_get('upload_max_filesize') . '</td></tr>';
	echo '<tr><td>default_charset</td><td>' . ini_get('default_charset') . '</td></tr>';
	echo '</table>';

	// 3. MySQL section
	// =================================================

	// try to read the site's config files
	$config_files = 2;
	if (!is_file($location . 'configurations/ossn.config.site.php')) {
		echo '<pre>Error: <b>configurations/ossn.config.site.php</b> is missing</pre>';
		$config_files--;
	}
	if (!is_file($location . 'configurations/ossn.config.db.php')) {
		echo '<pre>Error: <b>configurations/ossn.config.db.php</b> is missing</pre>';
		$config_files--;
	}
	if($config_files < 2) {
		exit;
	}
	
	// At this stage we still don't know if we're getting a successfull database connection
	// in case of issues, connection warnings will go to apache2/error_log or a location we don't know
	// so we better set up our own handlers here

	// WARNING HANDLER to catch database issues in order not to expose db config details to the public
	set_error_handler(function ($severity, $message, $file, $line) {
		$db_problems = array(
			'Access denied for user' => 'Error: <b>Database access denied</b> - check user and password in configurations/ossn.config.db.php',
			'Unknown database' => 'Error: <b>Database unknown</b> - check database in configurations/ossn.config.db.php',
			'Temporary failure in name resolution' => 'Error: <b>Cannot resolve database host</b> - check host in configurations/ossn.config.db.php',
			'Connection timed out' => 'Error: <b>Database connection time out</b> - check host in configurations/ossn.config.db.php',
			'php_network_getaddresses' => 'Error: <b>Cannot resolve database host</b> - check host in configurations/ossn.config.db.php' 
		);
		$found = false;
		foreach($db_problems as $db_problem_key => $db_problem_value) {
			$pos = strpos($message, $db_problem_key);
			if($pos !== false) {
				echo '<pre>' . $db_problem_value . '</pre>';
				$found = true;
				break;
			}
		}
		if(!$found) {
			echo '<pre>' . $message . '</pre>';
		}
		exit;
	});

	// FATAL ERROR HANDLER to catch corrupted code
	register_shutdown_function(function () { 
		$error = error_get_last();
		if($error) {
			echo '<pre>' . $error['message'] . ' in <b>' . $error['file'] . '</b> on line <b>' . $error['line'] . '</b></pre>';
		}
		exit;
	});

	// try to establish the database connection based on site configuration files
	global $Ossn;
	if (!isset($Ossn)) {
		$Ossn = new stdClass;
	}
	include($location . '/configurations/ossn.config.db.php');
	include($location . '/configurations/ossn.config.site.php');
	$connect  = new mysqli($Ossn->host, $Ossn->user, $Ossn->password, $Ossn->database, $Ossn->port);

	echo '<h3>MySQL Environment</h3>';
	echo '<table>';
	$query = "SELECT SUM( data_length + index_length)  'db_size_in_mb' FROM information_schema.TABLES WHERE table_schema='$Ossn->database' ;";
	$exec  = $connect->query($query);
	$row   = $exec->fetch_assoc();
	echo '<tr><td>Server Info</td><td>' . $connect->server_info . '</td></tr>';
	echo '<tr><td>Host Info</td><td>' . $connect->host_info . '</td></tr>';
	echo '<tr><td>Port</td><td>' . $Ossn->port . '</td></tr>';
	echo '<tr><td>Protocol Version</td><td>' . $connect->protocol_version . '</td></tr>';
	echo '<tr><td>Ossn DataBase Size</td><td>' . $row['db_size_in_mb'] . ' bytes</td></tr>';
	$query = "SELECT * FROM information_schema.SCHEMATA WHERE schema_name='$Ossn->database' ;";
	$exec  = $connect->query($query);
	$row   = $exec->fetch_assoc();
	echo '<tr><td>Character Set</td><td>' . $row['DEFAULT_CHARACTER_SET_NAME'] . '</td></tr>';
	echo '<tr><td>Collation</td><td>' . $row['DEFAULT_COLLATION_NAME'] . '</td></tr>';
	echo '<tr><td>Stats</td><td>';
	$dbstats = explode("  ", $connect->stat());
	foreach($dbstats as $dbstat) {
		echo $dbstat . '<br />';
	}
	echo '</td></tr>';
	echo '<tr><td>Client Version</td><td>' . $connect->client_version . '</td></tr>';
	echo '</table>';
	
	// verify if we have Ossn tables at all (should be at least 11)
	$query = "SELECT COUNT(table_schema) FROM information_schema.TABLES WHERE table_schema = '$Ossn->database' ;";
	$exec  = $connect->query($query);
	$row   = $exec->fetch_assoc();
	if ($row['COUNT(table_schema)'] < MINIMUM_NUMBER_OF_TABLES) {
		exit('<pre><b>Error: Database table(s) missing - import database backup or re-install Ossn</b></pre>');
	}

	// verify if we have at least one admin user
	$query = "SELECT COUNT(type) FROM ossn_users WHERE type = 'admin' ;";
	$exec  = $connect->query($query);
	$row   = $exec->fetch_assoc();
	if ($row['COUNT(type)'] < MINIMUM_NUMBER_OF_ADMINS) {
		exit('<pre><b>Error: Admin user missing - import database backup or re-install Ossn</b></pre>');
	}

	// in case we proceeded successfully up to here
	// we can use a more tolerant warning handler that won't exit anymore
	set_error_handler(function ($severity, $message, $file, $line) {
		 // echo '<pre>' . $message . '</pre>';
	});

	// 4. Ossn main section
	// =================================================

	// enable Ossn error reporting in advance
	// if start succeeds errors go to error_log
	// if not we stay with our former handler
	$query = "UPDATE ossn_site_settings SET value = 'on' WHERE name = 'display_errors' ;";
	$connect->query($query);

	echo '<h3>Ossn Environment</h3>';
	echo '<table>';

	// get site settings
	$query = "SELECT * FROM `ossn_site_settings` WHERE 1 ;";
	$exec  = $connect->query($query);
	$rows  = $exec->fetch_all();
	$db_site_settings = array();
	foreach($rows as $row) {
		$db_site_settings[$row[1]] = $row[2];
	}

	// disable-chache option
	$cache_disabled_msg = '';
	$protection_violation_msg = '';
	if($key === 'disable' && $value === 'cache' && $db_site_settings['cache'] === '1') {
		if($protect_password_checked) {
			$query = "UPDATE ossn_site_settings SET value = '0' WHERE name = 'cache' ;";
			$connect->query($query);
			$query = "UPDATE ossn_site_settings SET value = '0' WHERE name = 'last_cache' ;";
			$connect->query($query);
			tool_system_info_delFolder($location . 'cache/');
			tool_system_info_delFolder($Ossn->userdata . 'system/');
			$db_site_settings['cache'] = '0';
			$cache_disabled_msg = '<pre class=success><b>SUCCESS: Cache has been disabled</b></pre>';
		}
		else {
			$protection_violation_msg = '<pre class=attention><b>ACCESS DENIED: Site configuration changes can be applied in password protected mode, only</b></pre>';
		}
	}

	if($version_file['version'] != $db_site_settings['site_version']) {
		$mark = 'attention';
		echo '<tr class=' . $mark . '><td>Version (according to files)</td><td>' . $version_file['version'] . '</td></tr>';
		echo '<tr class=' . $mark . '><td>Version (according to database)</td><td>' . $db_site_settings['site_version'] . '</td></tr>';
	} else {
		echo '<tr><td>Version</td><td>' . $db_site_settings['site_version'] . '</td></tr>';
	}
	$package = 'Free';
	if (strpos($version_file['licence'], 'commercial') !== false) {
		$package = 'Premium';
	}
	echo '<tr><td>Release / Package</td><td>' . $version_file['release'] . ' / ' . $package . '</td></tr>';
	echo '<tr><td>Site URL</td><td>' . $Ossn->url . '</td></tr>';
	echo '<tr><td>Install Dir</td><td>' . $location . '</td></tr>';
	if (function_exists('posix_getpwuid')) {
		$owner_perms = posix_getpwuid(fileowner($location))['name'] . ' [' . substr(sprintf('%o', fileperms($location)), -4) . ']';
	}
	else {
		$owner_perms = fileowner($location) . ' [' . substr(sprintf('%o', fileperms($location)), -4) . ']';
	}
	echo '<tr><td>Install Dir Owner(Id) [Perms]</td><td>' . $owner_perms . '</td></tr>';
	$data_dir = $Ossn->userdata;
	echo '<tr><td>Data Dir</td><td>' . $data_dir . '</td></tr>';
	if (function_exists('posix_getpwuid')) {
		$owner_perms = posix_getpwuid(fileowner($data_dir))['name'] . ' [' . substr(sprintf('%o', fileperms($data_dir)), -4) . ']';
	}
	else {
		$owner_perms = fileowner($data_dir) . ' [' . substr(sprintf('%o', fileperms($data_dir)), -4) . ']';
	}
	echo '<tr><td>Data Dir Owner(Id) [Perms]</td><td>' . $owner_perms . '</td></tr>';
	echo '<tr><td>Data Dir Size</td><td>' . tool_system_info_folderSize($data_dir) . ' bytes</td></tr>';
	echo '<tr><td>Site Notification Email</td><td>' . $db_site_settings['notification_email'] . '</td></tr>';
	echo '<tr><td>Site Language</td><td>' . $db_site_settings['language'] . '</td></tr>';
	echo '<tr><td>Cache State</td><td id=cache_state>' . $db_site_settings['cache'] . '</td></tr>';
	$query = "SELECT TABLE_ROWS FROM information_schema.TABLES WHERE TABLE_NAME ='ossn_users' ;";
	$exec  = $connect->query($query);
	$row   = $exec->fetch_assoc();
	$total_members = $row['TABLE_ROWS'];
	echo '<tr><td>Members</td><td>' . $total_members . '</td></tr>';
	echo '<tr><td>Error Reporting</td><td>' . $db_site_settings['display_errors'] . '</td></tr>';
	echo '</table>';

	// some messages ...
	// check stable installation
	if($version_file['stable_version'] != $db_site_settings['site_version']) {
		echo '<pre><b>FATAL: You missed to update Ossn correctly - run <i>' . $Ossn->url . 'upgrade/upgrade.php </i>as soon as possible</b></pre>';
	} elseif ($version_file['version'] != $db_site_settings['site_version']) {
		echo '<pre class=warning><b>WARINING: Developer versions are not intended for use in production environments </b></pre>';
	}
	
	// check copyright manipulation
	$active_language_file = $location . 'locale/ossn.' . $db_site_settings['language'] . '.php';
	$content = file_get_contents($active_language_file);
	$pos = strpos($content, 'Powered by the Open Source Social Network.');
	if ($pos === false && $package === 'Free') {
		echo '<pre><b>FATAL: This site stopped working due to a copyright message manipulation - restore original line </b></pre>';
	}
	
	// display cache-disabled message
	echo $cache_disabled_msg;
	// or cache-enabled message to be inserted by script later
	echo '<div id=cache_enabled_msg></div>';
	// or access denied message
	echo $protection_violation_msg;
	// access denied on trying to enable cache by script later
	echo '<div id=protection_violation_msg></div>';
	
	// 5. Retrieve checksum for Ossn core files
	// =================================================

	$tmp_checksum_file = $location . TMP_CHECKSUM_FILE;
	@unlink($tmp_checksum_file);
	// find the right checksum file based on version from xml file
	$version = $version_file['version'];
	// sanitize version string to be used as allowed php var
	$version = str_replace('.', '_', $version);
	$version = str_replace(' ', '_', $version);
	$checksum_array_available = false;
	$checksum_array_name = CHECKSUM_REPOSITORY_URL . 'checksums_' . $version . '_' . $version_file['release'];
	$tmp_checksum_array = explode("\n", tool_system_info_http_get_contents($checksum_array_name));
	// generate warning in case no Ossn core checksums available
	if (in_array("<html><head>", $tmp_checksum_array)) {
		echo '<pre><b>WARINING: No Ossn Core checksums available </b></pre>';
	} else {
		$checksum_array = array();
		foreach($tmp_checksum_array as $entry) {
			$tmp = explode(" ", $entry);
			$checksum_array[$tmp[0]] = $tmp[1];
		}
		if(count($checksum_array)) {
			$checksum_array_available = true;
		}
	}

	// 6. Ossn components section
	// =================================================

	echo '<h3>Ossn Components</h3>';
	echo '<table>';
	echo '<tr><td>Component <span style=font-family:courier>(Component Id)</span></td><td>Version</td><td>Active</td><td>Modified</td></tr>';
	$query = "SELECT * FROM `ossn_components` WHERE 1 ;";
	$exec  = $connect->query($query);
	$rows  = $exec->fetch_all();
	$db_components = array();
	// get available components
	foreach($rows as $row) {
		$db_components[$row[1]] = $row[2];
	}
	$component_state_change_msg = '';
	$protection_violation_msg = '';
	$disable_cache_first_msg = '';
	// disable-component option
	if($key === 'disable' && array_key_exists($value, $db_components) && $db_components[$value] !== '0') {
		if($protect_password_checked && $db_site_settings['cache'] === '0') {
			$query = "UPDATE ossn_components SET active = 0 WHERE com_id = '$value' ;";
			$connect->query($query);
			$db_components[$value] = '0';
			$component_state_change_msg = '<pre class=success><b>SUCCESS: <i>' . $value . '</i> disabled</b></pre>';
		}
		else {
			if(!$protect_password_checked) {
				$protection_violation_msg = '<pre class=attention><b>ACCESS DENIED: Site configuration changes can be applied in password protected mode, only</b></pre>';
			}
			if($protect_password_checked && $db_site_settings['cache'] !== '0') {
				$disable_cache_first_msg = '<pre class=attention><b>ATTENTION: Site configuration changes can be applied only if cache has been disabled</b></pre>';
			}
		}
	}
	// enable-component option
	if($key === 'enable' && array_key_exists($value, $db_components) && $db_components[$value] !== '1') {
		if($protect_password_checked && $db_site_settings['cache'] === '0') {
			$query = "UPDATE ossn_components SET active = 1 WHERE com_id = '$value' ;";
			$connect->query($query);
			$db_components[$value] = '1';
			$component_state_change_msg = '<pre class=success><b>SUCCESS: <i>' . $value . '</i> enabled</b></pre>';
		}
		else {
			if(!$protect_password_checked) {
				$protection_violation_msg = '<pre class=attention><b>ACCESS DENIED: Site configuration changes can be applied in password protected mode, only</b></pre>';
			}
			if($protect_password_checked && $db_site_settings['cache'] !== '0') {
				$disable_cache_first_msg = '<pre class=attention><b>ATTENTION: Site configuration changes can be applied only if cache has been disabled</b></pre>';
			}
		}
	}
	foreach($db_components as $com_id => $active) {
		$dir = $location . 'components/' . $com_id;
		$com_more_details = file_get_contents($dir . '/ossn_com.xml');
		$com_more_details = (array)simplexml_load_string($com_more_details);
		$checksum = tool_system_info_MD5_DIR($dir, $tmp_checksum_file);
		if($active == '1') {
			$active = '+';
		}
		else {
			$active = '';
		}
		$color = 'warning';
		$modified = '???';
		$orig_checksum = false;
		// if a component comes with its own checksum file this file takes precedence 
		// so let's check availability first
		if (file_exists($location . 'components/' . $com_id . '/' . SINGLE_CHECKSUM_FILE)) {
			$orig_checksum = file_get_contents($location . 'components/' . $com_id . '/' . SINGLE_CHECKSUM_FILE, FALSE, NULL, 0, 32);
		} elseif ($checksum_array_available === true) {
			// try to get checksum from array
			$orig_checksum = $checksum_array['components/' . $com_id];
		}
		if($orig_checksum) {
			if($orig_checksum == $checksum) {
				$color = 'confirmed';
				$modified = '';
			} else {
				$color = 'attention';
				$modified = 'yes';
			}
		}
		$different_id = '';
		if($com_more_details['name'] != $com_id) {
			$different_id = ' <span style=font-family:courier>(' . $com_id . ')</span>';
		}
		echo '<tr><td>' . $com_more_details['name'] . $different_id . '</td><td>' . $com_more_details['version'] . '</td><td>' . $active . '</td><td class=' . $color . '>' . $modified . '</td></tr>';
		unlink($tmp_checksum_file);
	}
	echo '</table>';
	
	echo $component_state_change_msg;
	echo $protection_violation_msg;
	echo $disable_cache_first_msg;

	// 7. Ossn themes section
	// =================================================

	echo '<h3>Ossn Themes</h3>';
	echo '<table>';
	echo '<tr><td>Theme <span style=font-family:courier>(Theme Id)</span></td><td>Version</td><td>Active</td><td>Modified</td></tr>';
	$all_themes = tool_system_info_getThemes($location . 'themes/');
	$active_theme = $db_site_settings['theme'];
	$theme_state_change_msg = '';
	$protection_violation_msg = '';
	$disable_cache_first_msg = '';
	// theme setting option
	if($key === 'theme' && count($all_themes) > 1 && in_array($value, $all_themes) && $value !== $active_theme) {
		if($protect_password_checked && $db_site_settings['cache'] === '0') {
			$query = "UPDATE ossn_site_settings SET value = '$value' WHERE name = 'theme' ;";
			$connect->query($query);
			$active_theme = $value;
			$theme_state_change_msg = '<pre class=success><b>SUCCESS: <i>' . $value . '</i> enabled</b></pre>';
		}
		else {
			if(!$protect_password_checked) {
				$protection_violation_msg = '<pre class=attention><b>ACCESS DENIED: Site configuration changes can be applied in password protected mode, only</b></pre>';
			}
			if($protect_password_checked && $db_site_settings['cache'] !== '0') {
				$disable_cache_first_msg = '<pre class=attention><b>ATTENTION: Site configuration changes can be applied only if cache has been disabled</b></pre>';
			}
		}
	}
	foreach($all_themes as $theme) {
		$dir = $location . 'themes/' . $theme;
		$theme_more_details = file_get_contents($dir . '/ossn_theme.xml');
		$theme_more_details = (array)simplexml_load_string($theme_more_details);
		$checksum = tool_system_info_MD5_DIR($dir, $tmp_checksum_file);
		if($active_theme == $theme) {
			$active = '+';
		}
		else {
			$active = '';
		}
		$color = 'warning';
		$modified = '???';
		$orig_checksum = false;
		if (file_exists($location . 'themes/' . $theme . '/' . SINGLE_CHECKSUM_FILE)) {
			$orig_checksum = file_get_contents($location . 'themes/' . $theme . '/' . SINGLE_CHECKSUM_FILE, FALSE, NULL, 0, 32);
		} elseif ($checksum_array_available === true) {
			$orig_checksum = $checksum_array['themes/' . $theme];
		}
		if($orig_checksum) {
			if($orig_checksum == $checksum) {
				$color = 'confirmed';
				$modified = '';
			} else {
				$color = 'attention';
				$modified = 'yes';
			}
		}
		$different_id = '';
		if($theme_more_details['name'] != $theme) {
			$different_id = ' <span style=font-family:courier>(' . $theme . ')</span>';
		}
		echo '<tr><td>' . $theme_more_details['name'] . $different_id . '</td><td>' . $theme_more_details['version'] . '</td><td>' . $active . '</td><td class=' . $color . '>' . $modified . '</td></tr>';
		unlink($tmp_checksum_file);
	}	
	echo '</table>';

	echo $theme_state_change_msg;
	echo $protection_violation_msg;
	echo $disable_cache_first_msg;

	// 8. Ossn core section
	// =================================================

	echo '<h3>Ossn Core</h3>';
	echo '<table>';
	echo '<tr><td>Division</td><td>Modified</td></tr>';
	$devisions = array('actions', 'classes', 'libraries', 'locale', 'system', 'upgrade', 'vendors');
	foreach($devisions as $devision) {
		$dir = $location . '/' . $devision;
		$checksum = tool_system_info_MD5_DIR($dir, $tmp_checksum_file);
		$color = 'warning';
		$modified = '???';
		$orig_checksum = false;
		if (file_exists($dir . '/' . SINGLE_CHECKSUM_FILE)) {
			$orig_checksum = file_get_contents($dir . '/' . SINGLE_CHECKSUM_FILE, FALSE, NULL, 0, 32);
		} elseif ($checksum_array_available === true) {
			$orig_checksum = $checksum_array[$devision];
		}
		if($orig_checksum) {
			if($orig_checksum == $checksum) {
				$color = 'confirmed';
				$modified = '';
			} else {
				$color = 'attention';
				$modified = 'yes';
			}
		}
		echo '<tr><td>' . $devision . '</td><td class=' . $color . '>' . $modified . '</td></tr>';
		unlink($tmp_checksum_file);
	}
	echo '</table>';

	// 9. Ossn init performance check
	// =================================================

	// in case Ossn crashes after the error handler in lib.system has been already set up
	// we won't see an error message here (it'll be saved in error_log instead)
	// so place a common message in advance which will be hidden if start completes successfully
	echo '<div id=tool_system_info_error_msg>
	<pre><b>FATAL: Ossn initializing failure</b> - check the last lines of your <b><i>error_log</i></b> file<br />or run <b><i>ossninfo.php?view=files</i></b>
	</pre></div>';
	// try to init Ossn
	define('OSSN_ALLOW_SYSTEM_START', TRUE);
	$start = $location . 'system/start.php';
	$time_before_init = number_format(microtime(true) - $_SERVER["REQUEST_TIME_FLOAT"], 3);
	require_once($start);
	$time_after_init = number_format(microtime(true) - $_SERVER["REQUEST_TIME_FLOAT"], 3);
	$init_time = $time_after_init - $time_before_init;
	// start completed successfully - hide error message
	echo '<style>#tool_system_info_error_msg {display:none}</style>';

	// enable-cache option (finally available if init was successful)
	if($key === 'enable' && $value === 'cache' && $db_site_settings['cache'] === '0') {
		if($protect_password_checked) {
			if(ossn_create_cache()) {
				// insert messages in Ossn environment table by script
				echo "<script>document.getElementById('cache_state').innerHTML = '1';</script>";
				echo "<script>document.getElementById('cache_enabled_msg').innerHTML = '<pre class=success><b>SUCCESS: Cache has been enabled</b></pre>';</script>";
			} else {
				echo "<script>document.getElementById('cache_enabled_msg').innerHTML = '<pre class=attention><b>ATTENTION: Problem while enabling cache - check <i>error_log</i> file</b></pre>';</script>";
			}
		}
		else {
			echo "<script>document.getElementById('protection_violation_msg').innerHTML = '<pre class=attention><b>ACCESS DENIED: Site configuration changes can be applied in password protected mode, only</b></pre>';</script>";
		}
	}
	

	// 10. Site pageload performance check
	// =================================================

	echo '<iframe src=' . $Ossn->url . '></iframe>';
	echo '<h3>Ossn Performance</h3>';
	echo '<table>';
	echo '<tr><td>Ossn Core Init Time</td><td>' . $init_time . ' s</td></tr>';
	echo "<tr><td>Page Loading Time</td><td id='plt'></td></tr>";
	echo '</table>';
	echo '<br />';
	echo "<script> document.addEventListener('readystatechange', function() { if (document.readyState == 'complete') { document.getElementById('plt').innerHTML = ((parseInt(performance.now()) / 1000))  + ' s'; }});</script>";
	echo '</body> </html>';
	exit();


function tool_system_info_MD5_DIR($dir, $tmp_checksum_file) {
	$file = '';
    if (!is_dir($dir)) {
        return false;
    }
    $d = dir($dir);
    while (false !== ($entry = $d->read())) {
        if ($entry != '.' && $entry != '..') {
             if (is_dir($dir.'/'.$entry)) {
				 tool_system_info_MD5_DIR($dir.'/'.$entry, $tmp_checksum_file);
             }
             else {
				 if($entry !== 'ossn_chk.md5') {
					$md5_hash = md5_file($dir.'/'.$entry) . "\n";
					file_put_contents($tmp_checksum_file, $md5_hash, FILE_APPEND);
				 }
             }
        }
    }
    $d->close();
	$checksums = explode("\n", file_get_contents($tmp_checksum_file));
	array_pop($checksums);
	sort($checksums);
	$sorted_checksums = implode("\n", $checksums);
	file_put_contents($tmp_checksum_file, $sorted_checksums);
	file_put_contents($tmp_checksum_file, "\n", FILE_APPEND);
	return md5_file($tmp_checksum_file);
}

function tool_system_info_getSystemMemInfo() {       
    $data = explode("\n", file_get_contents('/proc/meminfo'));
    $meminfo = array();
    foreach ($data as $line) {
        @list($key, $val) = explode(":", $line);
		if($key) {
			$meminfo[$key] = trim($val);
		}
    }
    return $meminfo;
}

function tool_system_info_folderSize($dir) {
    $size = 0;
    foreach (glob(rtrim($dir, '/').'/*', GLOB_NOSORT) as $each) {
        $size += is_file($each) ? filesize($each) : tool_system_info_folderSize($each);
    }
    return $size;
}

function tool_system_info_delFolder($dir) {
	if(is_dir($dir)) {
		$files = array_diff(scandir($dir), array('.','..'));
		foreach ($files as $file) {
			(is_dir("$dir/$file") && !is_link($dir)) ? tool_system_info_delFolder("$dir/$file") : unlink("$dir/$file");
		}
		return rmdir($dir);
	}
}

function tool_system_info_dump($params = '') {
	if (!empty($params)) {
		ob_start();
		echo '<pre>';
		print_r($params);
		echo '</pre>';
		$content = ob_get_contents();
		ob_end_clean();
		return $content;
	}
	return false;
}

function tool_system_info_http_get_contents($url) {
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_TIMEOUT, 1);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	if(FALSE === ($retval = curl_exec($ch))) {
		error_log(curl_error($ch));
	} else {
		return $retval;
	}
}

function tool_system_info_getThemes($theme_path) {
	$dir       = $theme_path;
	$theme_ids = array();
	$handle    = opendir($dir);
				
	if($handle) {
		while($theme_id = readdir($handle)) {
			if(substr($theme_id, 0, 1) !== '.' && is_dir($dir . $theme_id) && !preg_match('/\s/', $theme_id) && is_file("{$dir}{$theme_id}/ossn_theme.php") && is_file("{$dir}{$theme_id}/ossn_theme.xml")) {
				$theme_ids[] = $theme_id;
			}
		}
	}
				
	sort($theme_ids);
	return $theme_ids;
}

function tool_system_info_getFileList($dir, $recurse = false, $depth = false) {
    $retval = [];

    if(substr($dir, -1) != "/") {
      $dir .= "/";
    }

    $d = @dir($dir) or die("tool_system_info_getFileList: Failed opening directory {$dir} for reading");
    while(false !== ($entry = $d->read())) {
		//if($entry{0} == ".") continue;
		if(is_dir("{$dir}{$entry}")) {
			if($entry{0} == ".") continue;
			$stat = stat("{$dir}{$entry}");
			if (function_exists('posix_getpwuid')) {
				$owner = posix_getpwuid($stat['uid'])['name'];;
			}
			else {
				$owner = $stat['uid'];
			}

			$retval[] = [
				'name' => substr("{$dir}{$entry}/", 2),
				'type' => filetype("{$dir}{$entry}"),
				'size' => $stat['size'],
				'lastmod' => $stat['mtime'],
				'perms' => substr(sprintf('%o', $stat['mode']), -4),
				'owner' => $owner,
			];
			if($recurse && is_readable("{$dir}{$entry}/")) {
				if($depth === FALSE) {
					$retval = array_merge($retval, tool_system_info_getFileList("{$dir}{$entry}/", true));
				} elseif($depth > 0) {
					$retval = array_merge($retval, tool_system_info_getFileList("{$dir}{$entry}/", true, $depth - 1));
				}
			}
		} elseif(is_readable("{$dir}{$entry}")) {
			$stat = stat("{$dir}{$entry}");
			if (function_exists('posix_getpwuid')) {
				$owner = posix_getpwuid($stat['uid'])['name'];;
			}
			else {
				$owner = $stat['uid'];
			}

			$retval[] = [
				'name' => substr("{$dir}{$entry}", 2),
				'type' => mime_content_type("{$dir}{$entry}"),
				'size' => $stat['size'],
				'lastmod' => $stat['mtime'],
				'perms' => substr(sprintf('%o', $stat['mode']), -4),
				'owner' => $owner,
			];
		}
    }
    $d->close();
    return $retval;
}

function tool_system_info_openPortScan($host) {
	$from = 1;
	$to = 1024;
	$ports = array();
	$count = 0;
	
	for($port = $from; $port <= $to ; $port++) {
		$fp = @fsockopen($host, $port);
		if ($fp) {
			$ports[] = $port;
			fclose($fp);
			$count++;
		}	 
	}
	
	if(!$count) {
		$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);  
		for($port = $from; $port <= $to ; $port++) {
			$connection = @socket_connect($socket, $host, $port);
			if ($connection) {
				$ports[] = $port;
				socket_close($socket);
				$socket = socket_create(AF_INET , SOCK_STREAM , SOL_TCP);  
			}	 
		}
	}
	
	return implode(", ", $ports);
}
