<?php
/**
 * Open Source Social Network
 *
 * @package   Open Source Social Network
 * @author    Informatikon Core Team <info@softlab24.com>
 * @copyright (C) SOFTLAB24 LIMITED
 * @license   Open Source Social Network License (OSSN LICENSE)  http://www.opensource-socialnetwork.org/licence
 * @link      http://www.informatikon.com/
 */

define('SYSTEM_INFO_VERSION', '2.5');

error_reporting(E_ALL);
ini_set("display_errors", 1);

$dir = '';
$verify = '';
if(!empty($_GET['path'])) {
	$dir = $_GET['path'];
}

echo "<style>
	body, td, th, h1, h2 {
    font-family: courier;
	margin: revert !important;
	}
	pre {
		font-size: 16px;
		color: red;
	}
	b { color: red}
	.bluegray {
		color:blue;
		background:#f0f0f0;
	}
</style>";

echo '<h2>Verifyperms ' . SYSTEM_INFO_VERSION . '</h2>';

// check existance of .htaccess
$pos = false;
if(file_exists('.htaccess')) {
	$content = file_get_contents('.htaccess');
	$pos = strpos($content, '<Files "error_log">');
}
if($pos === false || !file_exists('.htaccess')) {
	// append rule to protect error_log in case it's not available
	$fh = fopen('.htaccess', "a");
	fwrite($fh, "\n" . '<Files "error_log">' . "\n\t" . 'order allow,deny' . "\n\t" . 'deny from all' . "\n" . '</Files>' . "\n");
	fclose($fh);
}
		
// check for password protection
$protected = false;
$protect_password_checked = false;
if(file_exists('error_log')) {
	$fn = fopen('error_log', 'r');
	$firstline = fgets($fn);
	fclose($fn);
	$pos = strpos($firstline, 'system-info-password');
	if($pos !== false) {
		$protect_password_array = explode(" ", $firstline);
		$protect_password = $protect_password_array[1];
		$protected = true;
	}
}
foreach($_GET as $key => $value) {
	if($protected && !$protect_password_checked) {
		if($key !== 'password') {
			exit('<pre><b>FATAL: Password required - add <i>?password=YourPassword</i> to URL</b></pre>');
		}
		if($value !== substr($protect_password, 0, strlen($protect_password) - 1)) {
			exit('<pre><b>FATAL: Wrong password - access denied</b></pre>');
		}
		$protect_password_checked = true;
	}
}
if($protected && !$protect_password_checked) {
	exit('<pre><b>FATAL: Password required - add <i>?password=YourPassword</i> to URL</b></pre>');
}

$path_parm_1 = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['SERVER_NAME'] . '/verifyperms.php?path=../ossn_community_data';
$path_parm_2 = '?path=../../ossn_community_data';

if($protected) {
	$path_parm_1 = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['SERVER_NAME'] . '/verifyperms.php?password=YourPassword&path=../ossn_community_data';
	$path_parm_2 = '&path=../../ossn_community_data';
}

$temp_file = tmpfile();
$temp_path = stream_get_meta_data($temp_file)['uri'];
$temp_owner = fileowner($temp_path);
if (function_exists('posix_getpwuid')) {
	$temp_owner = posix_getpwuid($temp_owner)['name'];
	echo "The owner of your webserver process is: <b>" . $temp_owner . "</b><br />";
} else {
	echo "The owner-id of your webserver process is: " . $temp_owner . "<br />";
}	
fclose($temp_file);

echo "
<br />
<u>1. Check Ossn installation directory</u><br />
Running <i>verifyperms.php</i> without additional parameters will scan your Ossn installation directory<br />
in order to asure that subdirectories and files can be created and/or modified without problems.<br />
In case of wrong ownership and/or access rights, either use your FTP tool's <i>properties</i> tab to fix the issues<br />
or ask your provider how to achieve web server ownership and write permissions for your Ossn installation directory<br />
including all of its files and subdirectories.<br />
<br />
<u>2. Check Ossn data directory</u><br />
Since the Ossn data directory must be located in a parent directory of your Ossn installation,<br />
re-run <i>verifyperms.php</i> by adding a 'path' parameter to the URL in order to verify the data directory you created.<br />
Hence, in case the the name of the data directory is 'ossn_community_data' you would run verifyperms like<br /> 
<span class=bluegray>"
. $path_parm_1 .
"</span><br />
(To scan the parent of the parent you would use <span style='color:blue; background:#f0f0f0'>"
. $path_parm_2 .
"</span> and so on)<br /><br />
";

$path = getcwd().'/' . $dir;
if(strlen($dir)) {
	if(strrpos($dir, '.') + 1 ===  strlen($dir) || strrpos($dir, '/') + 1 ===  strlen($dir)) {
		exit('<pre><b>Fatal: ambigious path <i>' . $path . '</i> - add the exact name of your data directory to path parameter in URL</b></pre>');
	}
}

if(!realpath($path)) {
	exit('<pre><b>Fatal: <i>' . $path . '</i> not found - check path parameter in URL and/or existance of directory</b></pre>');
}
echo '<br /><br />Scanning: ' . realpath($path) . '<br /><br />';
echo "<div id='message'>No permission problems found.</div>";

verify_perms(realpath($path), $temp_owner, $verify);
exit;


function verify_perms($dir, $temp_owner, $verify) {
    if (!is_dir($dir)) {
        return false;
    }
	
	$probs = false;

	if (empty($verify) || (!empty($verify) && $verify == basename($dir))){
	$current_owner = fileowner($dir);
	if (function_exists('posix_getpwuid')) {
		$current_owner = posix_getpwuid($current_owner)['name'];
	}
	if($temp_owner != $current_owner) {
		$probs = true; 
		echo "<br>Permission problem found!<br />
		The owner of " . $dir . " is: <b>" . $current_owner . "</b> - please change to: <b>" . $temp_owner . "</b><br />";
	}
	$current_perms = substr(sprintf('%o', fileperms($dir)), -4);
	if(substr($current_perms, 0, 3) != '075') {
		$probs = true;
		echo "<br>Permission problem found!<br />
		The access permission of " . $dir . " is: <b>" . $current_perms . "</b> - please change to: <b>0755</b><br />";
	}
	}
    $d = dir($dir);
    while (false !== ($entry = $d->read())) {
        if ($entry != '.' && $entry != '..') {
            if (is_dir($dir.'/'.$entry)) {
				verify_perms($dir.'/'.$entry, $temp_owner, $verify);
            }
            else {
				// echo $dir . '/' . $entry . "<br />";
				if (empty($verify) || (!empty($verify) && $verify == $entry)){
				$current_owner = fileowner($dir . '/' . $entry);
				if (function_exists('posix_getpwuid')) {
					$current_owner = posix_getpwuid($current_owner)['name'];
				}
				if($temp_owner != $current_owner) {
					$probs = true;
					echo "<br>Permission problem found!<br />
					The owner of " . $dir . '/' . $entry . " is: <b>" . $current_owner . "</b> - please change to: <b>" . $temp_owner . "</b><br />";
				}
				$current_perms = substr(sprintf('%o', fileperms($dir . '/' . $entry)), -4);
				if(substr($current_perms, 0, 3) != '064') {
					$probs = true;
					echo "<br>Permission problem found!<br />
					The access permission of " . $dir . '/' . $entry . " is: <b>" . $current_perms . "</b> - please change to: <b>0644</b><br />";
				}
				}
            }
        }
    }
    $d->close();
	if ($probs) {
		?>
		<script>
		document.getElementById("message").setAttribute("style", "display: none;"); 
		</script>
		<?php
	}
}

?>