<?php
/**
 * Open Source Social Network
 * @link      https://www.opensource-socialnetwork.org/
 * @package   System Info
 * @author    Michael Zülsdorff <ossn@z-mans.net>
 * @copyright (C) Michael Zülsdorff
 * @license   GNU General Public License https://www.gnu.de/documents/gpl-2.0.en.html
 */

define('SYSTEM_INFO_VERSION', '6.5');
// temporary file used for checksum computing
define('TMP_CHECKSUM_FILE', 'checksum.tmp');
// file containing single checksum to be found in root of component or theme directory
define('SINGLE_CHECKSUM_FILE', 'ossn_chksum.md5');
// repository url of bundled release checksums
define('CHECKSUM_REPOSITORY_URL', 'https://z-mans.net/ossn-checksums/');

define('__SYSTEM_INFO__', ossn_route()->com . 'system-info/');

function ossn_system_info()
{
	ossn_extend_view('css/ossn.default', 'system-info/css/component');
	ossn_register_page('ossn-system-info', 'ossn_system_info_page');

	if (ossn_isAdminLoggedin()) {
		ossn_register_com_panel('system-info', 'settings');
		ossn_register_action('admin/system-info/settings', __SYSTEM_INFO__ . 'actions/settings.php');		

		ossn_register_sections_menu('newsfeed', array(
			'name' => 'system-info-ossninfo',
			'text' => 'Ossn Info',
			'url' => ossn_site_url('ossn-system-info'),
			'section' => 'com-system-info-section',
		));	
		ossn_register_sections_menu('newsfeed', array(
			'name' => 'system-info-files',
			'text' => 'Files',
			'url' => ossn_site_url('ossn-system-info/files'),
			'section' => 'com-system-info-section',
		));	
		ossn_register_sections_menu('newsfeed', array(
			'name' => 'system-info-phpinfo',
			'text' => 'PHP Info',
			'url' => ossn_site_url('ossn-system-info/phpinfo'),
			'section' => 'com-system-info-section',
		));	
		ossn_register_sections_menu('newsfeed', array(
			'name' => 'system-info-meminfo',
			'text' => 'Mem Info',
			'url' => ossn_site_url('ossn-system-info/meminfo'),
			'section' => 'com-system-info-section',
		));	
		ossn_register_sections_menu('newsfeed', array(
			'name' => 'system-info-openports',
			'text' => 'Open Ports',
			'url' => ossn_site_url('ossn-system-info/openports'),
			'section' => 'com-system-info-section',
		));	
	}
}

function ossn_system_info_page()
{
	$comp = new OssnComponents;
	$settings = $comp->getSettings('system-info');
	$remember_password_setting_msg = '';
	if (ossn_isAdminLoggedin()) {
		if (!$settings) {
			redirect('administrator/component/system-info');
		} elseif ($settings && $settings->{'system-info:password'} === '') {
			$remember_password_setting_msg = ossn_print('com-system-info-page-remember-password-setting-msg');
		}
	} else {
		if (!$settings || ($settings && $settings->{'system-info:password'} === '')  || ($settings && $settings->{'system-info:password'} !== $_REQUEST['password'])) {
			ossn_error_page();
		}
	} 

	echo"
	<!DOCTYPE html>
	<html lang='en'>
	<head>
	<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
	<style>
	table {
		border-collapse: collapse;
	}
	td, th {
		border: 1px solid #000000;
		font-size: 100%;
		vertical-align: baseline;
		padding: 5px;
	}
	body, td, th, h1, h2 {
		font-family: sans-serif;
		margin: revert !important;
	}
	pre {
		font-size: 16px;
		color: red;
	}
	table pre {
		color: black;
	}
	iframe {
		height: 0px;
		width: 0px;
		border-width: 0px;
	}
	.attention {
		color: red;
	}
	.warning {
		color: #007aff;
	}
	.confirmed {
		color: black;
	}
	.success {
		color: green;
	}
	.button-danger {
		font-size: 16px;
		color: red;
	}
	button {
		margin-top: 30px;
		margin-bottom: 30px;
		color: white;
		background: dodgerblue;
		font-size: 16px;
	}
	</style></head>";

	echo '<body>';

	foreach ($_GET as $key => $value) {
		if ($value === 'files') {
			$files = array('opensource-socialnetwork.xml', '.htaccess', 'php.ini', '.php.ini', '.user.ini', 'error_log');
			echo $remember_password_setting_msg;
			foreach ($files as $file) {
				echo '--------------------------------------------------------------------------------------<br />';
				echo $file . ':<br />';
				echo '--------------------------------------------------------------------------------------<br />';
				$file = ossn_route()->www . $file;
				if (file_exists($file)) {
					echo '<pre style=color:black>' . htmlentities(file_get_contents($file)) . '</pre>';
				} else {
					echo '<pre>no such file</pre>';
				}
				echo '<br />';
			}
			com_system_info_back_button();
			exit;
		}
		if ($value === 'phpinfo') {
			echo $remember_password_setting_msg;
			phpinfo();
			com_system_info_back_button();
			exit;
		}
		if ($value === 'meminfo') {
			echo $remember_password_setting_msg;
			echo '<h3>Server Environment</h3>';
			echo '<table>';
			echo '<tr><td>Operating System</td><td>' . php_uname() . '</td></tr>';
			echo '<tr><td>Memory Info</td><td>' . ossn_dump(com_system_info_getSystemMemInfo()) . '</td></tr>';
			echo '</table>';
			com_system_info_back_button();
			exit;
		}
		if ($value === 'openports') {
			echo $remember_password_setting_msg;
			echo '<h3>Scan for open ports ...</h3>';
			echo '<br />';
			echo 'CAUTION: Portscans on shared hosts may cause your provider to temporarely block your site or may cause other unpredictable issues.';
			echo '<br /><br />';
			echo '<form action="/ossn-system-info/portscan" enctype="multipart/form-data">
					<input class="button-danger" type="submit" value="I don\'t care - just do it.">
					</form>';
			com_system_info_back_button();
			exit;
		}
		if ($value === 'portscan') {
			echo $remember_password_setting_msg;
			echo '<h3>Scan for open ports ...</h3>';
			echo '<br />';
			$open_ports = com_system_info_openPortScan($_SERVER['SERVER_NAME']);
			echo '<span class="confirmed"><b>' . $open_ports . '</b></span>';
			echo '<pre class="success"><b>Scan completed</b>';
			com_system_info_back_button();
			exit;
		}
		if ($value !== 'ossn-system-info') {
			if ($value === $_REQUEST['password']) {
				continue;
			}
			echo '<pre>no such option</pre>';
			com_system_info_back_button();
			exit;
		}
	}

	echo '<h2>Ossn System Info ' . SYSTEM_INFO_VERSION . '</h2>';
	echo $remember_password_setting_msg;
	echo '<br />';

	echo '<h3>Server Environment</h3>';
	echo '<table>';
	echo '<tr><td>Operating System</td><td>' . php_uname() . '</td></tr>';
	echo '<tr><td>Host Name</td><td>' . $_SERVER['SERVER_NAME'] . '</td></tr>';
	$dns_ip = $_SERVER['SERVER_ADDR'];
	echo '<tr><td>Host IP</td><td>' . $dns_ip . '</td></tr>';
	$reverse_domain = gethostbyaddr($dns_ip);
	echo '<tr><td>Host Name (reverse lookup)</td><td>' . $reverse_domain . '</td></tr>';
	echo '</table>';

	echo '<h3>PHP Environment</h3>';
	echo '<table>';
	echo '<tr><td>Version</td><td>' . PHP_VERSION . '</td></tr>';
	echo '<tr><td>Server APi</td><td>' . PHP_SAPI . '</td></tr>';
	echo '<tr><td>&nbsp;</td><td>&nbsp;</td></tr>';
	echo '<tr><td>memory_limit</td><td>' . ini_get('memory_limit') . '</td></tr>';
	echo '<tr><td>register_globals</td><td>' . ini_get('register_globals') . '</td></tr>';
	echo '<tr><td>post_max_size</td><td>' . ini_get('post_max_size') . '</td></tr>';
	echo '<tr><td>upload_max_filesize</td><td>' . ini_get('upload_max_filesize') . '</td></tr>';
	echo '<tr><td>default_charset</td><td>' . ini_get('default_charset') . '</td></tr>';
	echo '</table>';

	echo '<h3>MySQL Environment</h3>';
	echo '<table>';
	$settings = ossn_database_settings();
	global $Ossn;
	$connect  = new mysqli($Ossn->host, $Ossn->user, $Ossn->password, $Ossn->database, $Ossn->port);
	$query = "SELECT SUM( data_length + index_length)  'db_size_in_mb' FROM information_schema.TABLES WHERE table_schema='$settings->database' ;";
	$exec  = $connect->query($query);
	$row   = $exec->fetch_assoc();
	echo '<tr><td>Server Info</td><td>' . $connect->server_info . '</td></tr>';
	echo '<tr><td>Host Info</td><td>' . $connect->host_info . '</td></tr>';
	echo '<tr><td>Port</td><td>' . $settings->port . '</td></tr>';
	echo '<tr><td>Protocol Version</td><td>' . $connect->protocol_version . '</td></tr>';
	echo '<tr><td>Ossn DataBase Size</td><td>' . $row['db_size_in_mb'] . ' bytes</td></tr>';
	$query = "SELECT * FROM information_schema.SCHEMATA WHERE schema_name='$settings->database' ;";
	$exec  = $connect->query($query);
	$row   = $exec->fetch_assoc();
	echo '<tr><td>Character Set</td><td>' . $row['DEFAULT_CHARACTER_SET_NAME'] . '</td></tr>';
	echo '<tr><td>Collation</td><td>' . $row['DEFAULT_COLLATION_NAME'] . '</td></tr>';
	echo '<tr><td>Stats</td><td>';
	$dbstats = explode("  ", $connect->stat());
	foreach ($dbstats as $dbstat) {
		echo $dbstat . '<br />';
	}
	echo '</td></tr>';
	echo '<tr><td>Client Version</td><td>' . $connect->client_version . '</td></tr>';
	echo '</table>';

	echo '<h3>Ossn Environment</h3>';
	echo '<table>';
	$install_dir = ossn_route()->www;
	$version_file = file_get_contents($install_dir . 'opensource-socialnetwork.xml');
	$version_file = (array)simplexml_load_string($version_file);
	if ($version_file['version'] != ossn_site_settings('site_version')) {
		$mark = 'attention';
		echo '<tr class=' . $mark . '><td>Version (according to files)</td><td>' . $version_file['version'] . '</td></tr>';
		echo '<tr class=' . $mark . '><td>Version (according to database)</td><td>' . ossn_site_settings('site_version') . '</td></tr>';
	} else {
		echo '<tr><td>Version</td><td>' . ossn_site_settings('site_version') . '</td></tr>';
	}
	$package = 'Free';
	if (strpos($version_file['licence'], 'commercial') !== false) {
		$package = 'Premium';
	}
	echo '<tr><td>Release / Package</td><td>' . $version_file['release'] . ' / ' . $package . '</td></tr>';
	echo '<tr><td>Site URL</td><td>' . ossn_site_url() . '</td></tr>';
	echo '<tr><td>Install Dir</td><td>' . $install_dir . '</td></tr>';
	if (function_exists('posix_getpwuid')) {
		$owner_perms = posix_getpwuid(fileowner($install_dir))['name'] . ' [' . substr(sprintf('%o', fileperms($install_dir)), -4) . ']';
	}
	else {
		$owner_perms = fileowner($install_dir) . ' [' . substr(sprintf('%o', fileperms($install_dir)), -4) . ']';
	}
	echo '<tr><td>Install Dir Owner(Id) [Perms]</td><td>' . $owner_perms . '</td></tr>';
	$data_dir = ossn_get_userdata();
	echo '<tr><td>Data Dir</td><td>' . $data_dir . '</td></tr>';
	if (function_exists('posix_getpwuid')) {
		$owner_perms = posix_getpwuid(fileowner($data_dir))['name'] . ' [' . substr(sprintf('%o', fileperms($data_dir)), -4) . ']';
	}
	else {
		$owner_perms = fileowner($data_dir) . ' [' . substr(sprintf('%o', fileperms($data_dir)), -4) . ']';
	}
	echo '<tr><td>Data Dir Owner(Id) [Perms]</td><td>' . $owner_perms . '</td></tr>';
	echo '<tr><td>Data Dir Size</td><td>' . com_system_info_folderSize($data_dir) . ' bytes</td></tr>';
	echo '<tr><td>Site Notification Email</td><td>' . ossn_site_settings('notification_email') . '</td></tr>';
	echo '<tr><td>Site Language</td><td>' . ossn_site_settings('language') . '</td></tr>';
	echo '<tr><td>Cache State</td><td>' . ossn_site_settings('cache') . '</td></tr>';
	$users = new OssnUser;
	$total_members = $users->countByGender('female') + $users->countByGender('male');
	echo '<tr><td>Members</td><td>' . $total_members . '</td></tr>';
	echo '<tr><td>Error Reporting</td><td>' . ossn_site_settings('display_errors') . '</td></tr>';
	echo '</table>';

	if ($version_file['stable_version'] != ossn_site_settings('site_version')) {
		echo '<pre><b>FATAL: You missed to update Ossn correctly - run <i>' . ossn_site_url() . 'upgrade/upgrade.php </i>as soon as possible</b></pre>';
	} elseif ($version_file['version'] != ossn_site_settings('site_version')) {
		echo '<pre><b>WARINING: Developer versions are not intended for use in production environments </b></pre>';
	}
	
	if (ossn_print('powered') !== 'Powered by the Open Source Social Network.' && $package === 'Free') {
		echo '<pre><b>FATAL: This site stopped working due to a copyright message manipulation - restore original line </b></pre>';
	}
	
	$tmp_checksum_file = $install_dir . TMP_CHECKSUM_FILE;
	if (file_exists($tmp_checksum_file)) {
		unlink($tmp_checksum_file);
	}
	$version = $version_file['version'];
	$version = str_replace('.', '_', $version);
	$version = str_replace(' ', '_', $version);
	$checksum_array_available = false;
	$checksum_array_name = CHECKSUM_REPOSITORY_URL . 'checksums_' . $version . '_' . $version_file['release'];
	$tmp_checksum_array = explode("\n", com_system_info_http_get_contents($checksum_array_name));
	if (in_array("<html><head>", $tmp_checksum_array)) {
		echo '<pre><b>WARINING: No Ossn Core checksums available </b></pre>';
	} else {
		$checksum_array = array();
		foreach ($tmp_checksum_array as $entry) {
			$tmp = explode(" ", $entry);
			$checksum_array[$tmp[0]] = $tmp[1];
		}
		if (count($checksum_array)) {
			$checksum_array_available = true;
		}
	}

	echo '<h3>Ossn Components</h3>';
	echo '<table>';
	echo '<tr><td>Component</td><td>Version</td><td>Active</td><td>Modified</td></tr>';
	$coms = new OssnComponents;
	$all_coms = $coms->getComponents();
	foreach ($all_coms as $com) {
		$com_details = $coms->getbyName($com);
		$com_more_details   = $coms->getCom($com);
		$dir = $install_dir . 'components/' . $com_details->com_id;
		$checksum = com_system_info_MD5_DIR($dir, $tmp_checksum_file);
		if ($com_details->active == '1') {
			$active = '+';
		}
		else {
			$active = '';
		}
		$color = 'warning';
		$modified = '???';
		$orig_checksum = false;
		if (file_exists($install_dir . 'components/' . $com_details->com_id . '/' . SINGLE_CHECKSUM_FILE)) {
			$orig_checksum = file_get_contents($install_dir . 'components/' . $com_details->com_id . '/' . SINGLE_CHECKSUM_FILE, FALSE, NULL, 0, 32);
		} elseif ($checksum_array_available === true) {
			$orig_checksum = $checksum_array['components/' . $com_details->com_id];
		}
		if ($orig_checksum) {
			if ($orig_checksum == $checksum) {
				$color = 'confirmed';
				$modified = '';
			} else {
				$color = 'attention';
				$modified = 'yes';
			}
		}
		echo '<tr><td>' . $com_more_details->name . '</td><td>' . $com_more_details->version . '</td><td>' . $active . '</td><td class=' . $color . '>' . $modified . '</td></tr>';
		unlink($tmp_checksum_file);
	}
	echo '</table>';

	echo '<h3>Ossn Themes</h3>';
	echo '<table>';
	echo '<tr><td>Theme</td><td>Version</td><td>Active</td><td>Modified</td></tr>';
	$themes = new OssnThemes;
	$all_themes = $themes->getThemes();
	$active_theme = $themes->getActive();
	foreach ($all_themes as $theme) {
		$theme_more_details = $themes->getTheme($theme);
		$dir = $install_dir . 'themes/' . $theme;
		$checksum = com_system_info_MD5_DIR($dir, $tmp_checksum_file);
		if ($active_theme == $theme) {
			$active = '+';
		}
		else {
			$active = '';
		}
		$color = 'warning';
		$modified = '???';
		$orig_checksum = false;
		if (file_exists($install_dir . 'themes/' . $theme . '/' . SINGLE_CHECKSUM_FILE)) {
			$orig_checksum = file_get_contents($install_dir . 'themes/' . $theme . '/' . SINGLE_CHECKSUM_FILE, FALSE, NULL, 0, 32);
		} elseif ($checksum_array_available === true) {
			$orig_checksum = $checksum_array['themes/' . $theme];
		}
		if ($orig_checksum) {
			if ($orig_checksum == $checksum) {
				$color = 'confirmed';
				$modified = '';
			} else {
				$color = 'attention';
				$modified = 'yes';
			}
		}
		echo '<tr><td>' . $theme_more_details->name . '</td><td>' . $theme_more_details->version . '</td><td>' . $active . '</td><td class=' . $color . '>' . $modified . '</td></tr>';
		unlink($tmp_checksum_file);
	}
	echo '</table>';

	echo '<h3>Ossn Core</h3>';
	echo '<table>';
	echo '<tr><td>Division</td><td>Modified</td></tr>';
	$devisions = array('actions', 'classes', 'libraries', 'locale', 'system', 'upgrade', 'vendors');
	foreach ($devisions as $devision) {
		$dir = $install_dir . '/' . $devision;
		$checksum = com_system_info_MD5_DIR($dir, $tmp_checksum_file);
		$color = 'warning';
		$modified = '???';
		$orig_checksum = false;
		if (file_exists($dir . '/' . SINGLE_CHECKSUM_FILE)) {
			$orig_checksum = file_get_contents($dir . '/' . SINGLE_CHECKSUM_FILE, FALSE, NULL, 0, 32);
		} elseif ($checksum_array_available === true) {
			$orig_checksum = $checksum_array[$devision];
		}
		if ($orig_checksum) {
			if ($orig_checksum == $checksum) {
				$color = 'confirmed';
				$modified = '';
			} else {
				$color = 'attention';
				$modified = 'yes';
			}
		}
		echo '<tr><td>' . $devision . '</td><td class=' . $color . '>' . $modified . '</td></tr>';
		unlink($tmp_checksum_file);
	}
	echo '</table>';

	echo '<iframe src=' . ossn_site_url() . '></iframe>';
	echo '<h3>Ossn Performance</h3>';
	echo '<table>';
	echo '<tr><td>Script Processing Time</td><td>' . number_format(microtime(true) - $_SERVER["REQUEST_TIME_FLOAT"], 3) . ' s</td></tr>';
	echo "<tr><td>Page Loading Time</td><td id='plt'></td></tr>";
	echo '</table>';
	echo '<br />';
	echo "<script> document.addEventListener('readystatechange', function() { if (document.readyState == 'complete') { document.getElementById('plt').innerHTML = ((parseInt(performance.now()) / 1000))  + ' s'; }});</script>";
	com_system_info_back_button();
	exit();
}

function com_system_info_back_button()
{
	echo "<form action='" . ossn_site_url() . "'><button type=submit><-- Back</button></form>";
	echo '</body> </html>';
}

function com_system_info_MD5_DIR($dir, $tmp_checksum_file)
{
	$file = '';
	if (!is_dir($dir)) {
	return false;
	}
	$d = dir($dir);
	while (false !== ($entry = $d->read())) {
		if ($entry != '.' && $entry != '..' && $entry != 'locale') {
			if (is_dir($dir.'/'.$entry)) {
				com_system_info_MD5_DIR($dir.'/'.$entry, $tmp_checksum_file);
			}
			else {
				if ($entry !== SINGLE_CHECKSUM_FILE) {
					$md5_hash = md5_file($dir.'/'.$entry) . "\n";
					file_put_contents($tmp_checksum_file, $md5_hash, FILE_APPEND);
				}
			}
		}
	}
	$d->close();
	$checksums = explode("\n", file_get_contents($tmp_checksum_file));
	array_pop($checksums);
	sort($checksums);
	$sorted_checksums = implode("\n", $checksums);
	file_put_contents($tmp_checksum_file, $sorted_checksums);
	file_put_contents($tmp_checksum_file, "\n", FILE_APPEND);
	return md5_file($tmp_checksum_file);
}

function com_system_info_getSystemMemInfo()
{
	$loglevel = error_reporting();
	error_reporting(0);	
	$file_contents = file_get_contents('/proc/meminfo');
	error_reporting($loglevel);	
	if ($file_contents) {
		$data = explode("\n", $file_contents);
		$meminfo = array();
		foreach ($data as $line) {
			if (strlen($line)) {
				@list($key, $val) = explode(":", $line);
				if ($key) {
					$meminfo[$key] = trim($val);
				}
			}
		}
		return $meminfo;
	} else {
		return ossn_print('com-system-info-meminfo-access-denied');
	}
}

function com_system_info_folderSize($dir)
{
	$size = 0;
	foreach (glob(rtrim($dir, '/').'/*', GLOB_NOSORT) as $each) {
		$size += is_file($each) ? filesize($each) : com_system_info_folderSize($each);
	}
	return $size;
}

function com_system_info_http_get_contents($url)
{
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_TIMEOUT, 1);
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	if (FALSE === ($retval = curl_exec($ch))) {
		error_log(curl_error($ch));
	} else {
		return $retval;
	}
}

function com_system_info_openPortScan($host)
{
	$from = 1;
	$to = 1024;
	$ports = array();
	$count = 0;

	$loglevel = error_reporting();
	error_reporting(0);	
	for ($port = $from; $port <= $to ; $port++) {
		$fp = fsockopen($host, $port);
		if ($fp) {
			$ports[] = $port;
			fclose($fp);
			$count++;
		}
	}
	error_reporting($loglevel);

	if (!$count && function_exists('socket_create')) {
		$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);  
		for($port = $from; $port <= $to ; $port++) {
			$connection = @socket_connect($socket, $host, $port);
			if ($connection) {
				$ports[] = $port;
				socket_close($socket);
				$socket = socket_create(AF_INET , SOCK_STREAM , SOL_TCP);
			}
		}
	}
	
	return implode(", ", $ports);
}
ossn_register_callback('ossn', 'init', 'ossn_system_info');
